/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.opt.spring.webmvc;

import io.jstach.jstachio.output.ThresholdEncodedOutput;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

class ServletThresholdEncodedOutput
extends ThresholdEncodedOutput.OutputStreamThresholdEncodedOutput {
    private final HttpServletResponse response;

    public ServletThresholdEncodedOutput(Charset charset, HttpServletResponse response, int bufferLimit) {
        super(charset, ServletThresholdEncodedOutput.calculateLimit(response, bufferLimit));
        this.response = response;
    }

    private static int calculateLimit(HttpServletResponse response, int bufferLimit) {
        return Math.max(response.getBufferSize(), bufferLimit);
    }

    protected OutputStream createConsumer(int size) throws IOException {
        if (size > -1) {
            this.response.setContentLength(size);
            this.response.setBufferSize(0);
        }
        return this.response.getOutputStream();
    }
}

