/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.opt.spring.webmvc;

import io.jstach.jstachio.JStachio;
import io.jstach.opt.spring.webmvc.JStachioModelView;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import org.springframework.util.ClassUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

public class ViewResolvingHandlerInterceptor
implements HandlerInterceptor,
WebMvcConfigurer {
    private final JStachio jstachio;

    public ViewResolvingHandlerInterceptor(JStachio jstachio) {
        this.jstachio = jstachio;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (modelAndView == null || !HandlerMethod.class.isInstance(handler)) {
            return;
        }
        HandlerMethod method = (HandlerMethod)handler;
        View view = this.view(method.getReturnType().getParameterType(), modelAndView.getModel());
        if (view != null) {
            modelAndView.setView(view);
        }
    }

    private View view(Class<?> modelClass, Map<String, Object> model) {
        if (!this.jstachio.supportsType(modelClass)) {
            return null;
        }
        Object value = this.attribute(modelClass, model);
        if (value == null) {
            return null;
        }
        return JStachioModelView.of(value, JStachioModelView.DEFAULT_MEDIA_TYPE, this.jstachio);
    }

    private Object attribute(Class<?> modelClass, Map<String, Object> model) {
        String name = ClassUtils.getShortNameAsProperty(modelClass);
        if (ClassUtils.isAssignableValue(modelClass, (Object)model.get(name))) {
            return model.get(name);
        }
        for (String key : model.keySet()) {
            if (!ClassUtils.isAssignableValue(modelClass, (Object)model.get(key))) continue;
            return model.get(key);
        }
        return null;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this);
    }
}

