/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.opt.spring.webmvc;

import io.jstach.opt.spring.webmvc.JStachioModelView;
import io.jstach.opt.spring.webmvc.JStachioModelViewConfigurer;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.springframework.context.ApplicationContext;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

public class ViewSetupHandlerInterceptor
implements HandlerInterceptor,
WebMvcConfigurer {
    private final List<JStachioModelViewConfigurer> configurers = new ArrayList<JStachioModelViewConfigurer>();
    private final ApplicationContext context;

    public ViewSetupHandlerInterceptor(ApplicationContext context) {
        for (String name : context.getBeanNamesForType(JStachioModelViewConfigurer.class)) {
            this.configurers.add((JStachioModelViewConfigurer)context.getBean(name));
        }
        this.context = context;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        @Nullable JStachioModelView view = this.findView(modelAndView);
        if (view != null) {
            Object page = view.model();
            for (JStachioModelViewConfigurer configurer : this.configurers) {
                configurer.configure(page, modelAndView.getModel(), request);
            }
        }
    }

    private @Nullable JStachioModelView findView(ModelAndView modelAndView) {
        if (modelAndView != null) {
            Object object;
            if (modelAndView.getView() instanceof JStachioModelView) {
                return (JStachioModelView)modelAndView.getView();
            }
            if (modelAndView.getView() instanceof View) {
                return null;
            }
            if (this.context.containsBean(modelAndView.getViewName()) && (object = this.context.getBean(modelAndView.getViewName())) instanceof JStachioModelView) {
                JStachioModelView view = (JStachioModelView)object;
                return view;
            }
        }
        return null;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this);
    }
}

