/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.opt.spring.web;

import io.jstach.jstachio.JStachio;
import io.jstach.jstachio.Output;
import io.jstach.opt.spring.web.HttpOutputMessageEncodedOutput;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class JStachioHttpMessageConverter
extends AbstractHttpMessageConverter<Object> {
    public static final MediaType DEFAULT_MEDIA_TYPE = new MediaType(MediaType.TEXT_HTML, StandardCharsets.UTF_8);
    public static final int DEFAULT_BUFFER_LIMIT = 65536;
    private final JStachio jstachio;
    private final MediaType mediaType;
    protected final int bufferLimit;

    public JStachioHttpMessageConverter(JStachio jstachio) {
        this(jstachio, DEFAULT_MEDIA_TYPE, 65536);
    }

    protected JStachioHttpMessageConverter(JStachio jstachio, MediaType mediaType, int bufferLimit) {
        super(JStachioHttpMessageConverter.resolveCharset(mediaType), new MediaType[]{mediaType, MediaType.ALL});
        this.jstachio = jstachio;
        this.mediaType = mediaType;
        this.bufferLimit = bufferLimit;
    }

    private static Charset resolveCharset(MediaType mediaType) {
        Charset charset = mediaType.getCharset();
        if (charset == null) {
            return StandardCharsets.UTF_8;
        }
        return charset;
    }

    protected boolean supports(Class<?> clazz) {
        return this.jstachio.supportsType(clazz);
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return this.jstachio.supportsType(clazz);
    }

    protected Object readInternal(Class<? extends Object> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        throw new HttpMessageNotReadableException("Input not supported by JStachio", inputMessage);
    }

    protected void writeInternal(Object t, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        HttpHeaders headers = outputMessage.getHeaders();
        headers.setContentType(this.mediaType);
        try (Output.CloseableEncodedOutput<IOException> output = this.createOutput(outputMessage);){
            this.jstachio.write(t, output);
        }
    }

    protected Output.CloseableEncodedOutput<IOException> createOutput(HttpOutputMessage message) {
        return new HttpOutputMessageEncodedOutput(this.getDefaultCharset(), message, this.bufferLimit);
    }
}

