/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.context;

import io.jstach.jstachio.context.IndexedContextNode;
import io.jstach.jstachio.context.NamedContextNode;
import io.jstach.jstachio.context.RootContextNode;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.jdt.annotation.Nullable;

public interface ContextNode
extends Iterable<ContextNode> {
    public static @Nullable ContextNode ofRoot(@Nullable Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof ContextNode) {
            ContextNode n = (ContextNode)o;
            if (n.parent() != null) {
                return ContextNode.ofRoot(n.object());
            }
            return n;
        }
        return new RootContextNode(o);
    }

    default public @Nullable ContextNode ofChild(String name, @Nullable Object o) throws IllegalArgumentException {
        if (o == null) {
            return null;
        }
        if (o instanceof ContextNode) {
            throw new IllegalArgumentException("Cannot wrap ContextNode around another ContextNode");
        }
        return new NamedContextNode(this, o, name);
    }

    default public @Nullable ContextNode ofChild(int index, @Nullable Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof ContextNode) {
            throw new IllegalArgumentException("Cannot wrap ContextNode around another ContextNode");
        }
        return new IndexedContextNode(this, o, index);
    }

    default public @Nullable ContextNode get(String field) {
        Object o = this.object();
        ContextNode child = null;
        if (o instanceof Map) {
            Map m = (Map)o;
            child = this.ofChild(field, m.get(field));
        }
        return child;
    }

    default public @Nullable ContextNode find(String field) {
        ContextNode child = this.get(field);
        if (child != null) {
            return child;
        }
        ContextNode parent = this.parent();
        if (parent != null && parent != this && (child = parent.find(field)) != null) {
            child = this.ofChild(field, child.object());
        }
        return child;
    }

    public Object object();

    default public String renderString() {
        return String.valueOf(this.object());
    }

    default public @Nullable ContextNode parent() {
        return null;
    }

    @Override
    default public Iterator<ContextNode> iterator() {
        Object o = this.object();
        if (o instanceof Iterable) {
            Iterable it = (Iterable)o;
            AtomicInteger index = new AtomicInteger();
            return StreamSupport.stream(it.spliterator(), false).map(i -> this.ofChild(index.getAndIncrement(), i)).iterator();
        }
        if (o == null || Boolean.FALSE.equals(o)) {
            return Collections.emptyIterator();
        }
        if (o.getClass().isArray()) {
            Stream<Number> s;
            if (o instanceof int[]) {
                int[] a = (int[])o;
                s = Arrays.stream(a).boxed();
            } else if (o instanceof long[]) {
                long[] a = (long[])o;
                s = Arrays.stream(a).boxed();
            } else if (o instanceof double[]) {
                double[] a = (double[])o;
                s = Arrays.stream(a).boxed();
            } else if (o instanceof boolean[]) {
                boolean[] a = (boolean[])o;
                ArrayList<Boolean> b = new ArrayList<Boolean>();
                for (boolean _a : a) {
                    b.add(_a);
                }
                s = b.stream();
            } else if (o instanceof char[]) {
                char[] a = (char[])o;
                ArrayList<Character> b = new ArrayList<Character>();
                for (char _a : a) {
                    b.add(Character.valueOf(_a));
                }
                s = b.stream();
            } else if (o instanceof byte[]) {
                byte[] a = (byte[])o;
                ArrayList<Byte> b = new ArrayList<Byte>();
                for (byte _a : a) {
                    b.add(_a);
                }
                s = b.stream();
            } else if (o instanceof float[]) {
                float[] a = (float[])o;
                ArrayList<Float> b = new ArrayList<Float>();
                for (float _a : a) {
                    b.add(Float.valueOf(_a));
                }
                s = b.stream();
            } else if (o instanceof short[]) {
                short[] a = (short[])o;
                ArrayList<Short> b = new ArrayList<Short>();
                for (short _a : a) {
                    b.add(_a);
                }
                s = b.stream();
            } else if (o instanceof Object[]) {
                Object[] a = (Object[])o;
                s = Arrays.asList(a).stream();
            } else {
                throw new IllegalArgumentException("array type not supported: " + o.getClass());
            }
            AtomicInteger index = new AtomicInteger();
            return s.map(i -> this.ofChild(index.getAndIncrement(), i)).iterator();
        }
        return Collections.singletonList(this).iterator();
    }

    public static boolean isFalsey(@Nullable Object context) {
        if (context == null) {
            return true;
        }
        if (Boolean.FALSE.equals(context)) {
            return true;
        }
        if (context instanceof Collection) {
            Collection c = (Collection)context;
            return c.isEmpty();
        }
        if (context instanceof Iterable) {
            Iterable it = (Iterable)context;
            return !it.iterator().hasNext();
        }
        if (context.getClass().isArray() && Array.getLength(context) == 0) {
            return false;
        }
        return false;
    }
}

