/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.escapers;

import io.jstach.jstachio.Escaper;
import java.io.IOException;

class HtmlEscaper
implements Escaper {
    private static final String QUOT = "&quot;";
    private static final String GT = "&gt;";
    private static final String LT = "&lt;";
    private static final String AMP = "&amp;";

    HtmlEscaper() {
    }

    @Override
    public void append(Appendable a, CharSequence s) throws IOException {
        s = s == null ? "null" : s;
        this.append(a, s, 0, s.length());
    }

    @Override
    public void append(Appendable a, CharSequence csq, int start, int end) throws IOException {
        csq = csq == null ? "null" : csq;
        block6: for (int i = start; i < end; ++i) {
            char c = csq.charAt(i);
            switch (c) {
                case '&': {
                    a.append(csq, start, i);
                    start = i + 1;
                    a.append(AMP);
                    continue block6;
                }
                case '<': {
                    a.append(csq, start, i);
                    start = i + 1;
                    a.append(LT);
                    continue block6;
                }
                case '>': {
                    a.append(csq, start, i);
                    start = i + 1;
                    a.append(GT);
                    continue block6;
                }
                case '\"': {
                    a.append(csq, start, i);
                    start = i + 1;
                    a.append(QUOT);
                }
            }
        }
        a.append(csq, start, end);
    }

    @Override
    public void append(Appendable a, char c) throws IOException {
        switch (c) {
            case '&': {
                a.append(AMP);
                break;
            }
            case '<': {
                a.append(LT);
                break;
            }
            case '>': {
                a.append(GT);
                break;
            }
            case '\"': {
                a.append(QUOT);
                break;
            }
            default: {
                a.append(c);
            }
        }
    }
}

