/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.spi;

import io.jstach.jstachio.Template;
import io.jstach.jstachio.TemplateInfo;
import io.jstach.jstachio.spi.BrokenFilter;
import io.jstach.jstachio.spi.CompositeFilterChain;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public interface JStachioFilter {
    public FilterChain filter(TemplateInfo var1, FilterChain var2);

    default public FilterChain filter(TemplateInfo template) {
        FilterChain previous = BrokenFilter.INSTANCE;
        if (template instanceof FilterChain) {
            FilterChain c = (FilterChain)((Object)template);
            previous = c;
        } else if (template instanceof Template) {
            Template t = (Template)template;
            previous = (model, appendable) -> t.execute(model, appendable);
        }
        return this.filter(template, previous);
    }

    default public int order() {
        return 0;
    }

    public static JStachioFilter compose(Iterable<JStachioFilter> filters) {
        ArrayList<JStachioFilter> fs = new ArrayList<JStachioFilter>();
        for (JStachioFilter f : filters) {
            fs.add(f);
        }
        fs.sort(Comparator.comparingInt(JStachioFilter::order));
        return new CompositeFilterChain(List.copyOf(fs));
    }

    public static interface FilterChain {
        public void process(Object var1, Appendable var2) throws IOException;

        default public boolean isBroken(Object model) {
            return false;
        }
    }
}

