/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.spi;

import io.jstach.jstache.JStache;
import io.jstach.jstache.JStacheConfig;
import io.jstach.jstache.JStacheContentType;
import io.jstach.jstache.JStacheFormatter;
import io.jstach.jstache.JStacheName;
import io.jstach.jstache.JStachePath;
import io.jstach.jstachio.Template;
import io.jstach.jstachio.TemplateInfo;
import io.jstach.jstachio.escapers.Html;
import io.jstach.jstachio.escapers.PlainText;
import io.jstach.jstachio.formatters.DefaultFormatter;
import io.jstach.jstachio.formatters.SpecFormatter;
import io.jstach.jstachio.spi.JStachioConfig;
import io.jstach.jstachio.spi.JStachioExtension;
import io.jstach.jstachio.spi.TemplateProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class Templates {
    private Templates() {
    }

    public static TemplateInfo findTemplate(Class<?> modelType, JStachioConfig config) throws Exception {
        try {
            Template<?> r = Templates.getTemplate(modelType);
            return r;
        }
        catch (Exception e) {
            Exception error = e;
            if (!config.getBoolean("jstachio.reflection.template.disable")) {
                System.Logger logger = config.getLogger(JStachioExtension.class.getCanonicalName());
                if (logger.isLoggable(System.Logger.Level.WARNING)) {
                    logger.log(System.Logger.Level.WARNING, "Could not find generated template and will try reflection for model type: " + modelType, (Throwable)error);
                }
                return Templates.getInfoByReflection(modelType);
            }
            throw error;
        }
    }

    public static TemplateInfo getInfoByReflection(Class<?> modelType) throws Exception {
        return TemplateInfos.templateOf(modelType);
    }

    public static <T> Template<T> getTemplate(Class<T> clazz) throws Exception {
        List<ClassLoader> classLoaders = Templates.collectClassLoaders(clazz.getClassLoader());
        return Templates.getTemplate(clazz, classLoaders);
    }

    private static <T> Template<T> getTemplate(Class<T> templateType, Iterable<ClassLoader> classLoaders) throws Exception {
        for (ClassLoader classLoader : classLoaders) {
            Template<T> template = Templates.doGetTemplate(templateType, classLoader);
            if (template == null) continue;
            return template;
        }
        throw new ClassNotFoundException("Cannot find implementation for " + templateType.getName());
    }

    private static <T> @Nullable Template<T> doGetTemplate(Class<T> clazz, ClassLoader classLoader) throws Exception {
        try {
            Class<?> implementation = classLoader.loadClass(Templates.resolveName(clazz));
            Constructor<?> constructor = implementation.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (Template)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            return Templates.getTemplateFromServiceLoader(clazz, classLoader);
        }
    }

    private static String resolveName(Class<?> c) {
        Object cname;
        JStache a = c.getAnnotation(JStache.class);
        if (a == null || a.name().isBlank()) {
            JStacheName name = Templates.findAnnotations(c, JStacheConfig.class).flatMap(config -> Stream.of(config.naming())).findFirst().orElse(null);
            String prefix = name == null ? "*" : name.prefix();
            String suffix = name == null ? "*" : name.suffix();
            prefix = prefix.equals("*") ? "" : prefix;
            suffix = suffix.equals("*") ? "Renderer" : suffix;
            cname = prefix + c.getSimpleName() + suffix;
        } else {
            cname = a.name();
        }
        String packageName = c.getPackageName();
        String fqn = packageName + (packageName.isEmpty() ? "" : ".") + (String)cname;
        return fqn;
    }

    private static <A extends Annotation> Stream<A> findAnnotations(Class<?> c, Class<A> annotationClass) {
        Stream<AnnotatedElement> s = Templates.annotationElements(c);
        return s.filter(p -> p != null).map(p -> p.getAnnotation(annotationClass)).filter(a -> a != null);
    }

    private static @NonNull Stream<AnnotatedElement> annotationElements(Class<?> c) {
        Stream<Class<?>> enclosing = Templates.enclosing(c);
        Stream<AnnotatedElement> s = Stream.concat(enclosing, Stream.of(c.getPackage(), c.getModule()));
        return s;
    }

    private static Stream<Class<?>> enclosing(final Class<?> e) {
        Spliterators.AbstractSpliterator split = new Spliterators.AbstractSpliterator<Class<?>>(Long.MAX_VALUE, 0){
            @Nullable Class<?> current;
            {
                super(arg0, arg1);
                this.current = e;
            }

            @Override
            public boolean tryAdvance(Consumer<? super Class<?>> action) {
                if (this.current == null) {
                    return false;
                }
                Class<?> c = this.current;
                this.current = this.current.getEnclosingClass();
                action.accept(c);
                return true;
            }
        };
        return StreamSupport.stream(split, false);
    }

    private static <T> @Nullable Template<?> getTemplateFromServiceLoader(Class<T> clazz, ClassLoader classLoader) {
        ServiceLoader<TemplateProvider> loader = ServiceLoader.load(TemplateProvider.class, classLoader);
        for (TemplateProvider rp : loader) {
            for (Template<?> t : rp.provideTemplates()) {
                if (!t.supportsType(clazz)) continue;
                return t;
            }
        }
        return null;
    }

    private static List<ClassLoader> collectClassLoaders(@Nullable ClassLoader classLoader) {
        return Stream.of(classLoader, Thread.currentThread().getContextClassLoader(), Template.class.getClassLoader()).filter(cl -> cl != null).toList();
    }

    static class TemplateInfos {
        TemplateInfos() {
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public static TemplateInfo templateOf(Class<?> model) throws Exception {
            Object templatePath;
            JStache stache = model.getAnnotation(JStache.class);
            if (stache == null) {
                throw new IllegalArgumentException("Model class is not annotated with " + JStache.class.getSimpleName() + ". class: " + model);
            }
            @Nullable JStachePath pathConfig = TemplateInfos.resolvePath(model);
            String templateString = stache.template();
            String templateName = Templates.resolveName(model);
            String path = stache.path();
            if (templateString.isEmpty() && path.isEmpty()) {
                Object folder = model.getPackageName().replace('.', '/');
                folder = ((String)folder).isEmpty() ? folder : (String)folder + "/";
                templatePath = (String)folder + model.getSimpleName();
            } else {
                templatePath = !path.isEmpty() ? path : "";
            }
            if (pathConfig != null && !((String)templatePath).isBlank()) {
                templatePath = pathConfig.prefix() + (String)templatePath + pathConfig.suffix();
            }
            Map.Entry ee = EscaperProvider.INSTANCE.providesFromModelType(model, stache);
            Function templateEscaper = (Function)ee.getValue();
            Class<?> templateContentType = ee.getKey();
            @Nullable Function templateFormatter = (Function)FormatterProvider.INSTANCE.providesFromModelType(model, stache).getValue();
            long lastLoaded = System.currentTimeMillis();
            return new SimpleTemplateInfo(templateName, (String)templatePath, templateString, templateContentType, templateEscaper, templateFormatter, lastLoaded, model);
        }

        private static JStachePath resolvePath(Class<?> model) {
            return Templates.annotationElements(model).map(TemplateInfos::resolvePathOnElement).filter(p -> p != null).findFirst().orElse(null);
        }

        private static @Nullable JStachePath resolvePathOnElement(AnnotatedElement a) {
            JStachePath path = a.getAnnotation(JStachePath.class);
            if (path != null) {
                return path;
            }
            JStacheConfig config = a.getAnnotation(JStacheConfig.class);
            if (config != null && config.pathing().length > 0) {
                return config.pathing()[0];
            }
            return null;
        }

        static enum EscaperProvider implements StaticProvider<Function<String, String>>
        {
            INSTANCE;


            @Override
            public Class<?> autoProvider() {
                return JStacheContentType.UnspecifiedContentType.class;
            }

            @Override
            public Class<?> defaultProvider() {
                return Html.class;
            }

            @Override
            public @Nullable Class<?> providerFromJStache(JStache jstache) {
                return null;
            }

            @Override
            public Class<?> providerFromConfig(JStacheConfig config) {
                return config.contentType();
            }

            @Override
            public String providesMethod(Class<?> type) {
                JStacheContentType a = type.getAnnotation(JStacheContentType.class);
                return a.providesMethod();
            }

            @Override
            public Function<String, String> provides(@Nullable Class<?> contentType) throws Exception {
                if ((contentType = this.nullToDefault(contentType)).equals(Html.class)) {
                    return Html.provides();
                }
                if (contentType.equals(PlainText.class)) {
                    return PlainText.provides();
                }
                return (Function)StaticProvider.super.provides(contentType);
            }
        }

        static enum FormatterProvider implements StaticProvider<Function<Object, String>>
        {
            INSTANCE;


            @Override
            public Class<?> autoProvider() {
                return JStacheFormatter.UnspecifiedFormatter.class;
            }

            @Override
            public Class<?> defaultProvider() {
                return DefaultFormatter.class;
            }

            @Override
            public @Nullable Class<?> providerFromJStache(JStache jstache) {
                return null;
            }

            @Override
            public Class<?> providerFromConfig(JStacheConfig config) {
                return config.formatter();
            }

            @Override
            public String providesMethod(Class<?> type) {
                JStacheFormatter a = type.getAnnotation(JStacheFormatter.class);
                return a.providesMethod();
            }

            @Override
            public Function<@Nullable Object, String> provides(@Nullable Class<?> formatterType) throws Exception {
                if ((formatterType = this.nullToDefault(formatterType)).equals(DefaultFormatter.class)) {
                    return DefaultFormatter.provides();
                }
                if (formatterType.equals(SpecFormatter.class)) {
                    return SpecFormatter.provides();
                }
                return (Function)StaticProvider.super.provides(formatterType);
            }
        }

        record SimpleTemplateInfo(String templateName, String templatePath, String templateString, Class<?> templateContentType, Function<String, String> templateEscaper, Function<@Nullable Object, String> templateFormatter, long lastLoaded, Class<?> modelClass) implements TemplateInfo
        {
            @Override
            public boolean supportsType(Class<?> type) {
                return this.modelClass().isAssignableFrom(type);
            }
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        static interface StaticProvider<P> {
            default public @Nullable Class<?> autoToNull(@Nullable Class<?> type) {
                if (type == null) {
                    return null;
                }
                if (type.equals(this.autoProvider())) {
                    return null;
                }
                return type;
            }

            default public Class<?> nullToDefault(@Nullable Class<?> type) {
                Class<?> c = this.autoToNull(type);
                if (c == null) {
                    return this.defaultProvider();
                }
                return c;
            }

            public String providesMethod(Class<?> var1);

            public Class<?> autoProvider();

            public Class<?> defaultProvider();

            public @Nullable Class<?> providerFromJStache(JStache var1);

            public Class<?> providerFromConfig(JStacheConfig var1);

            default public Class<?> findProvider(Class<?> modelType, JStache jstache) {
                @Nullable Class provider = this.autoToNull(this.providerFromJStache(jstache));
                if (provider != null) {
                    return provider;
                }
                provider = Templates.findAnnotations(modelType, JStacheConfig.class).map(config -> this.autoToNull(this.providerFromConfig((JStacheConfig)config))).filter(p -> p != null).findFirst().orElse(null);
                return this.nullToDefault(provider);
            }

            default public Map.Entry<Class<?>, P> providesFromModelType(Class<?> modelType, JStache jstache) throws Exception {
                Class<?> t = this.findProvider(modelType, jstache);
                return Map.entry(t, this.provides(t));
            }

            default public P provides(Class<?> type) throws Exception {
                String provides = this.providesMethod(type);
                Method method = type.getMethod(provides, new Class[0]);
                Object r = method.invoke((Object)provides, new Object[0]);
                return (P)r;
            }
        }
    }
}

