/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio;

import io.jstach.jstachio.JStachioHolder;
import io.jstach.jstachio.Output;
import io.jstach.jstachio.Renderer;
import io.jstach.jstachio.Template;
import io.jstach.jstachio.spi.JStachioFactory;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;

public interface JStachio
extends Renderer<Object> {
    @Override
    default public void execute(Object model, Appendable appendable) throws IOException {
        Renderer.super.execute(model, appendable);
    }

    @Override
    default public StringBuilder execute(Object model, StringBuilder sb) {
        return Renderer.super.execute(model, sb);
    }

    @Override
    default public String execute(Object model) {
        return Renderer.super.execute(model);
    }

    public <A extends Output.EncodedOutput<E>, E extends Exception> A write(Object var1, A var2) throws E;

    public Template<Object> findTemplate(Object var1) throws Exception;

    public boolean supportsType(Class<?> var1);

    public static void render(Object model, Appendable a) throws IOException {
        JStachio.of().execute(model, a);
    }

    public static StringBuilder render(Object model, StringBuilder a) {
        return JStachio.of().execute(model, a);
    }

    public static String render(Object model) {
        return JStachio.of().execute(model);
    }

    public static JStachio of() {
        return JStachioHolder.get();
    }

    public static JStachio defaults() {
        return JStachioFactory.defaultJStachio();
    }

    public static void setStatic(Supplier<JStachio> jstachioProvider) {
        if (Objects.isNull(jstachioProvider)) {
            throw new NullPointerException("JStachio provider cannot be null");
        }
        JStachioHolder.provider = jstachioProvider;
    }
}

