/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio;

import io.jstach.jstachio.AppendableOutput;
import io.jstach.jstachio.OutputAppendable;
import io.jstach.jstachio.OutputStreamOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public interface Output<E extends Exception> {
    public void append(CharSequence var1) throws E;

    default public void append(String s) throws E {
        this.append((CharSequence)s);
    }

    public void append(CharSequence var1, int var2, int var3) throws E;

    public void append(char var1) throws E;

    default public void append(short s) throws E {
        this.append(String.valueOf(s));
    }

    default public void append(int i) throws E {
        this.append(String.valueOf(i));
    }

    default public void append(long l) throws E {
        this.append(String.valueOf(l));
    }

    default public void append(double d) throws E {
        this.append(String.valueOf(d));
    }

    default public void append(boolean b) throws E {
        this.append(String.valueOf(b));
    }

    public static EncodedOutput<IOException> of(OutputStream a, Charset charset) {
        return new OutputStreamOutput(a, charset);
    }

    public static Output<IOException> of(Appendable a) {
        return new AppendableOutput(a);
    }

    public static StringOutput of(StringBuilder a) {
        return new StringOutput(a);
    }

    default public Appendable toAppendable() {
        Output output = this;
        if (output instanceof Appendable) {
            Appendable a = (Appendable)((Object)output);
            return a;
        }
        return new OutputAppendable(this);
    }

    public static class StringOutput
    implements Output<RuntimeException> {
        private final StringBuilder buffer;

        public StringOutput(StringBuilder buffer) {
            this.buffer = buffer;
        }

        @Override
        public void append(CharSequence s) {
            this.buffer.append(s);
        }

        @Override
        public void append(String s) {
            this.buffer.append(s);
        }

        @Override
        public void append(CharSequence csq, int start, int end) {
            this.buffer.append(csq, start, end);
        }

        @Override
        public void append(char c) {
            this.buffer.append(c);
        }

        public String toString() {
            return this.buffer.toString();
        }

        @Override
        public void append(boolean b) throws RuntimeException {
            this.buffer.append(b);
        }

        @Override
        public void append(double d) throws RuntimeException {
            this.buffer.append(d);
        }

        @Override
        public void append(int i) throws RuntimeException {
            this.buffer.append(i);
        }

        @Override
        public void append(long l) throws RuntimeException {
            this.buffer.append(l);
        }

        @Override
        public void append(short s) throws RuntimeException {
            this.buffer.append(s);
        }

        public StringBuilder getBuffer() {
            return this.buffer;
        }
    }

    public static interface CloseableEncodedOutput<E extends Exception>
    extends EncodedOutput<E>,
    AutoCloseable {
        @Override
        public void close() throws E;
    }

    public static interface EncodedOutput<E extends Exception>
    extends Output<E> {
        public void write(byte[] var1) throws E;

        default public void write(byte[] bytes, int off, int len) throws E {
            byte[] dest = new byte[len];
            System.arraycopy(bytes, off, dest, 0, len);
            this.write(dest);
        }

        @Override
        default public void append(char c) throws E {
            this.append(String.valueOf(c));
        }

        @Override
        default public void append(String s) throws E {
            this.write(s.getBytes(this.charset()));
        }

        @Override
        default public void append(CharSequence csq, int start, int end) throws E {
            this.append(csq.subSequence(start, end).toString());
        }

        public Charset charset();

        public static CloseableEncodedOutput<IOException> of(OutputStream a, Charset charset) {
            return new OutputStreamOutput(a, charset);
        }
    }
}

