/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.context;

import io.jstach.jstachio.Appender;
import io.jstach.jstachio.Formatter;
import io.jstach.jstachio.Output;
import io.jstach.jstachio.context.ContextNode;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
interface Internal
extends ContextNode {
    default public @Nullable ContextNode ofChild(String name, @Nullable Object o) throws IllegalArgumentException {
        return ContextNodeFactory.INSTANCE.ofChild((ContextNode)this, name, o);
    }

    default public @Nullable ContextNode ofChild(int index, @Nullable Object o) {
        return ContextNodeFactory.INSTANCE.ofChild((ContextNode)this, index, o);
    }

    @Override
    default public @Nullable ContextNode find(String field) {
        ContextNode child = this.get(field);
        if (child != null) {
            return child;
        }
        ContextNode parent = this.parent();
        if (parent != null && parent != this && (child = parent.find(field)) != null) {
            child = this.ofChild(field, child.object());
        }
        return child;
    }

    public static enum ContextNodeFactory {
        INSTANCE;


        @Nullable ContextNode ofChild(ContextNode parent, String name, @Nullable Object o) {
            if (o == null) {
                return null;
            }
            return this.create(parent, o);
        }

        @Nullable ContextNode ofChild(ContextNode parent, int index, @Nullable Object o) {
            if (o == null) {
                return null;
            }
            return this.create(parent, o);
        }

        ContextNode create(@Nullable ContextNode parent, Object o) {
            if (o instanceof ContextNode) {
                throw new IllegalArgumentException("Cannot wrap ContextNode around another ContextNode");
            }
            if (o instanceof Iterable) {
                Iterable it = (Iterable)o;
                return new IterableContextNode(it, parent);
            }
            if (o instanceof Map) {
                Map m = (Map)o;
                return new MapContextNode(m, parent);
            }
            if (o instanceof Optional) {
                Optional opt = (Optional)o;
                return new OptionalContextNode(opt, parent);
            }
            return new ValueContextNode(o, parent);
        }

        public Iterator<@Nullable ContextNode> iteratorOf(ContextNode parent, Iterable<?> it) {
            int[] j = new int[]{-1};
            return StreamSupport.stream(it.spliterator(), false).map(i -> {
                j[0] = j[0] + 1;
                return this.ofChild(parent, j[0], i);
            }).iterator();
        }

        public Iterator<@Nullable ContextNode> iteratorOf(ContextNode parent, @Nullable Object o) {
            if (o == null || Boolean.FALSE.equals(o)) {
                return Collections.emptyIterator();
            }
            if (o instanceof Iterable) {
                Iterable it = (Iterable)o;
                return this.iteratorOf(parent, o);
            }
            if (o instanceof Optional) {
                Optional opt = (Optional)o;
                return opt.stream().map(i -> this.ofChild(parent, 0, i)).iterator();
            }
            if (o.getClass().isArray()) {
                Stream<? extends @Nullable Object> s = ContextNodeFactory.arrayToStream(o);
                int[] j = new int[]{-1};
                return s.map(i -> {
                    j[0] = j[0] + 1;
                    return this.ofChild(parent, j[0], i);
                }).iterator();
            }
            return Collections.singletonList(parent).iterator();
        }

        private static Stream<? extends @Nullable Object> arrayToStream(Object o) {
            if (o instanceof int[]) {
                int[] a = (int[])o;
                return Arrays.stream(a).boxed();
            }
            if (o instanceof long[]) {
                long[] a = (long[])o;
                return Arrays.stream(a).boxed();
            }
            if (o instanceof double[]) {
                double[] a = (double[])o;
                return Arrays.stream(a).boxed();
            }
            if (o instanceof Object[]) {
                Object[] a = (Object[])o;
                return Arrays.asList(a).stream();
            }
            Stream.Builder<@Nullable Comparable<Boolean>> b = Stream.builder();
            if (o instanceof boolean[]) {
                boolean[] a;
                for (boolean _a : a = (boolean[])o) {
                    b.add(Boolean.valueOf(_a));
                }
            } else if (o instanceof char[]) {
                char[] a;
                for (char _a : a = (char[])o) {
                    b.add(Character.valueOf(_a));
                }
            } else if (o instanceof byte[]) {
                byte[] a;
                for (byte _a : a = (byte[])o) {
                    b.add(Byte.valueOf(_a));
                }
            } else if (o instanceof float[]) {
                float[] a;
                for (float _a : a = (float[])o) {
                    b.add(Float.valueOf(_a));
                }
            } else if (o instanceof short[]) {
                short[] a;
                for (short _a : a = (short[])o) {
                    b.add(Short.valueOf(_a));
                }
            } else {
                throw new IllegalArgumentException("array type not supported: " + o.getClass());
            }
            return b.build();
        }
    }

    public static enum EmptyContextNode implements Internal
    {
        EMPTY;


        @Override
        public Object object() {
            return Map.of();
        }

        @Override
        public @Nullable ContextNode get(String field) {
            return null;
        }

        @Override
        public @Nullable ContextNode find(String field) {
            return null;
        }

        @Override
        public Iterator<@Nullable ContextNode> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public <A extends Output<E>, E extends Exception> void format(Formatter formatter, Appender downstream, String path, A a) throws E {
            formatter.format(downstream, a, path, this.toString());
        }
    }

    public static final class MapContextNode
    extends Record
    implements ObjectContextNode {
        private final Map<?, ?> object;
        private final @Nullable ContextNode parent;

        public MapContextNode(Map<?, ?> object, @Nullable ContextNode parent) {
            this.object = object;
            this.parent = parent;
        }

        @Override
        public String toString() {
            return this.renderString();
        }

        @Override
        public @Nullable Object getValue(String key) {
            return this.object.get(key);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{MapContextNode.class, "object;parent", "object", "parent"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{MapContextNode.class, "object;parent", "object", "parent"}, this, o);
        }

        @Override
        public Map<?, ?> object() {
            return this.object;
        }

        @Override
        public @Nullable ContextNode parent() {
            return this.parent;
        }
    }

    public static final class FunctionContextNode
    extends Record
    implements ObjectContextNode {
        private final Function<String, ?> object;

        public FunctionContextNode(Function<String, ?> object) {
            this.object = object;
        }

        @Override
        public String toString() {
            return this.renderString();
        }

        @Override
        public @Nullable Object getValue(String key) {
            return this.object.apply(key);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FunctionContextNode.class, "object", "object"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FunctionContextNode.class, "object", "object"}, this, o);
        }

        @Override
        public Function<String, ?> object() {
            return this.object;
        }
    }

    public record ValueContextNode(Object object, @Nullable ContextNode parent) implements ValueNode
    {
        @Override
        public String toString() {
            return this.renderString();
        }

        @Override
        public Iterator<@Nullable ContextNode> iterator() {
            return ContextNodeFactory.INSTANCE.iteratorOf((ContextNode)this, this.object);
        }

        @Override
        public boolean isFalsey() {
            return ContextNode.isFalsey(this.object);
        }

        @Override
        public <A extends Output<E>, E extends Exception> void format(Formatter formatter, Appender downstream, String path, A a) throws E {
            Object o = this.object();
            formatter.format(downstream, a, path, o.getClass(), o);
        }
    }

    public static final class OptionalContextNode
    extends Record
    implements ValueNode {
        private final Optional<?> object;
        private final @Nullable ContextNode parent;

        public OptionalContextNode(Optional<?> object, @Nullable ContextNode parent) {
            this.object = object;
            this.parent = parent;
        }

        @Override
        public boolean isFalsey() {
            return this.object.isEmpty();
        }

        @Override
        public @NonNull Iterator<@Nullable ContextNode> iterator() {
            return this.object.stream().map(i -> this.ofChild(0, i)).iterator();
        }

        @Override
        public <A extends Output<E>, E extends Exception> void format(Formatter formatter, Appender downstream, String path, A a) throws E {
            throw new UnsupportedOperationException("Optional<?> node cannot be formatted. object: " + (Optional)this.object());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{OptionalContextNode.class, "object;parent", "object", "parent"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{OptionalContextNode.class, "object;parent", "object", "parent"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{OptionalContextNode.class, "object;parent", "object", "parent"}, this, o);
        }

        @Override
        public Optional<?> object() {
            return this.object;
        }

        @Override
        public @Nullable ContextNode parent() {
            return this.parent;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ValueNode
    extends Internal {
        @Override
        default public @Nullable ContextNode get(String field) {
            return null;
        }
    }

    public static final class IterableContextNode
    extends Record
    implements ListNode {
        private final Iterable<?> object;
        private final @Nullable ContextNode parent;

        public IterableContextNode(Iterable<?> object, @Nullable ContextNode parent) {
            this.object = object;
            this.parent = parent;
        }

        @Override
        public Iterator<@Nullable ContextNode> iterator() {
            return ContextNodeFactory.INSTANCE.iteratorOf((ContextNode)this, this.object);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{IterableContextNode.class, "object;parent", "object", "parent"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{IterableContextNode.class, "object;parent", "object", "parent"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{IterableContextNode.class, "object;parent", "object", "parent"}, this, o);
        }

        @Override
        public Iterable<?> object() {
            return this.object;
        }

        @Override
        public @Nullable ContextNode parent() {
            return this.parent;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ListNode
    extends Internal {
        @Override
        default public @Nullable ContextNode get(String field) {
            return null;
        }

        @Override
        public Iterator<@Nullable ContextNode> iterator();

        @Override
        default public <A extends Output<E>, E extends Exception> void format(Formatter formatter, Appender downstream, String path, A a) throws E {
            throw new UnsupportedOperationException("Possible bug. Iterable node cannot be formatted. object: " + this.object());
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ObjectContextNode
    extends Internal {
        public @Nullable Object getValue(String var1);

        @Override
        default public @Nullable ContextNode get(String field) {
            return this.ofChild(field, this.getValue(field));
        }

        @Override
        default public Iterator<@Nullable ContextNode> iterator() {
            return Collections.singleton(this).iterator();
        }

        @Override
        default public boolean isFalsey() {
            return false;
        }

        @Override
        default public <A extends Output<E>, E extends Exception> void format(Formatter formatter, Appender downstream, String path, A a) throws E {
            throw new UnsupportedOperationException("ContextNode cannot be formatted. object: " + this.object());
        }
    }
}

