/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.escapers;

import io.jstach.jstachio.Escaper;
import io.jstach.jstachio.Output;

enum HtmlEscaper implements Escaper
{
    HTML5;

    static final String QUOT = "&quot;";
    static final String AMP = "&amp;";
    static final String APOS = "&#x27;";
    static final String LT = "&lt;";
    static final String EQUAL = "&#x3D;";
    static final String GT = "&gt;";
    static final String BACK_TICK = "&#x60;";

    @Override
    public <A extends Output<E>, E extends Exception> void append(A a, CharSequence s) throws E {
        this.append(a, s, 0, s.length());
    }

    @Override
    public <A extends Output<E>, E extends Exception> void append(A a, CharSequence csq, int start, int end) throws E {
        block9: for (int i = start; i < end; ++i) {
            char c = csq.charAt(i);
            switch (c) {
                case '\"': {
                    a.append(csq, start, i);
                    start = i + 1;
                    a.append(QUOT);
                    continue block9;
                }
                case '&': {
                    a.append(csq, start, i);
                    start = i + 1;
                    a.append(AMP);
                    continue block9;
                }
                case '\'': {
                    a.append(csq, start, i);
                    start = i + 1;
                    a.append(APOS);
                    continue block9;
                }
                case '<': {
                    a.append(csq, start, i);
                    start = i + 1;
                    a.append(LT);
                    continue block9;
                }
                case '=': {
                    a.append(csq, start, i);
                    start = i + 1;
                    a.append(EQUAL);
                    continue block9;
                }
                case '>': {
                    a.append(csq, start, i);
                    start = i + 1;
                    a.append(GT);
                    continue block9;
                }
                case '`': {
                    a.append(csq, start, i);
                    start = i + 1;
                    a.append(BACK_TICK);
                    continue block9;
                }
            }
        }
        a.append(csq, start, end);
    }

    @Override
    public <A extends Output<E>, E extends Exception> void append(A a, char c) throws E {
        switch (c) {
            case '\"': {
                a.append(QUOT);
                break;
            }
            case '&': {
                a.append(AMP);
                break;
            }
            case '\'': {
                a.append(APOS);
                break;
            }
            case '<': {
                a.append(LT);
                break;
            }
            case '=': {
                a.append(EQUAL);
                break;
            }
            case '>': {
                a.append(GT);
                break;
            }
            case '`': {
                a.append(BACK_TICK);
                break;
            }
            default: {
                a.append(c);
            }
        }
    }

    @Override
    public <A extends Output<E>, E extends Exception> void append(A a, short s) throws E {
        a.append(s);
    }

    @Override
    public <A extends Output<E>, E extends Exception> void append(A a, int i) throws E {
        a.append(i);
    }

    @Override
    public <A extends Output<E>, E extends Exception> void append(A a, long l) throws E {
        a.append(l);
    }

    @Override
    public <A extends Output<E>, E extends Exception> void append(A a, double d) throws E {
        a.append(d);
    }

    @Override
    public <A extends Output<E>, E extends Exception> void append(A a, boolean b) throws E {
        a.append(b);
    }
}

