/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.output;

import io.jstach.jstachio.output.BufferedEncodedOutput;
import io.jstach.jstachio.output.LimitEncodedOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.eclipse.jdt.annotation.Nullable;

abstract class AbstractLimitEncodedOutput
implements LimitEncodedOutput<OutputStream, IOException> {
    private final BufferedEncodedOutput buffer;
    protected final int limit;
    protected @Nullable OutputStream consumer;
    protected int size = 0;
    protected final Charset charset;

    protected AbstractLimitEncodedOutput(BufferedEncodedOutput buffer, int limit) {
        this.buffer = buffer;
        this.limit = limit;
        this.charset = buffer.charset();
    }

    @Override
    public void write(byte[] chunk) throws IOException {
        int length = chunk.length;
        OutputStream c = this.consumer;
        if (c != null) {
            c.write(chunk);
        } else if (length + this.size > this.limit) {
            c = this.consumer = this.createConsumer(-1);
            this.buffer.transferTo(c);
            c.write(chunk);
        } else {
            this.buffer.write(chunk);
        }
        this.size += length;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public @Nullable OutputStream consumer() {
        return this.consumer;
    }

    protected abstract OutputStream createConsumer(int var1) throws IOException;

    protected void write(OutputStream consumer, byte[] bytes) throws IOException {
        consumer.write(bytes);
    }

    protected void close(OutputStream consumer) throws IOException {
        consumer.close();
    }

    @Override
    public Charset charset() {
        return this.charset;
    }

    @Override
    public void append(CharSequence s) throws IOException {
        this.append(s.toString());
    }

    @Override
    public void append(String s) throws IOException {
        this.write(s.getBytes(this.charset));
    }

    @Override
    public void close() throws IOException {
        OutputStream c = this.consumer;
        if (c == null) {
            this.consumer = c = this.createConsumer(this.size);
            this.buffer.transferTo(c);
        }
        this.close(c);
        this.consumer = null;
    }
}

