/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.spi;

import io.jstach.jstachio.JStachio;
import io.jstach.jstachio.Output;
import io.jstach.jstachio.Template;
import io.jstach.jstachio.TemplateInfo;
import io.jstach.jstachio.TemplateModel;
import io.jstach.jstachio.context.ContextJStachio;
import io.jstach.jstachio.context.ContextNode;
import io.jstach.jstachio.context.ContextTemplate;
import io.jstach.jstachio.spi.BrokenFilterException;
import io.jstach.jstachio.spi.JStachioExtensions;
import io.jstach.jstachio.spi.JStachioFilter;
import io.jstach.jstachio.spi.Templates;

public abstract class AbstractJStachio
implements JStachio,
JStachioExtensions.Provider,
ContextJStachio {
    @Override
    public <A extends Output<E>, E extends Exception> A execute(Object model, A appendable) throws E {
        Template<Object> t = this._findTemplate(model);
        return t.execute(AbstractJStachio._resolveModel(model), appendable);
    }

    @Override
    public <A extends Output.EncodedOutput<E>, E extends Exception> A write(Object model, A appendable) throws E {
        Template<Object> t = this._findTemplate(model);
        Templates.validateEncoding(t, appendable);
        return t.write(AbstractJStachio._resolveModel(model), appendable);
    }

    @Override
    public final <A extends Output.EncodedOutput<E>, E extends Exception> A write(Object model, ContextNode context, A output) throws E {
        Template<Object> t = this._findTemplate(model);
        Templates.validateEncoding(t, output);
        ContextTemplate<Object> ct = ContextTemplate.of(t);
        return ct.write(AbstractJStachio._resolveModel(model), context, output);
    }

    @Override
    public final <A extends Output<E>, E extends Exception> A execute(Object model, ContextNode context, A appendable) throws E {
        Template<Object> t = this._findTemplate(model);
        ContextTemplate<Object> ct = ContextTemplate.of(t);
        return ct.execute(AbstractJStachio._resolveModel(model), context, appendable);
    }

    @Override
    public final Template<Object> findTemplate(Object model) {
        return this._findTemplate(model);
    }

    private Template<Object> _findTemplate(Object model) {
        Template<?> template;
        if (model instanceof TemplateModel) {
            TemplateModel tm = (TemplateModel)model;
            template = tm.template();
            model = tm.model();
        } else {
            template = this.template(model.getClass());
        }
        JStachioFilter.FilterChain filter = this.loadFilter(model, template);
        Template<Object> t = JStachioFilter.FilterChain.toTemplate(filter, template);
        return t;
    }

    private static Object _resolveModel(Object model) {
        if (model instanceof TemplateModel) {
            TemplateModel tm = (TemplateModel)model;
            return tm.model();
        }
        return model;
    }

    protected final JStachioFilter.FilterChain loadFilter(Object model, TemplateInfo template) {
        JStachioFilter jstachioFilter = this.extensions().getFilter();
        JStachioFilter.FilterChain filter = JStachioFilter.FilterChain.of(jstachioFilter, template);
        if (filter.isBroken(model)) {
            boolean isReflectiveTemplate = Templates.isReflectionTemplate(template);
            String ind = "\n\t";
            String reason = "";
            if (isReflectiveTemplate) {
                reason = " This is usually because the template has not been compiled and reflection based rendering is not available.";
            }
            throw new BrokenFilterException("Filter chain unable to process template/model." + reason + "\n\ttemplate: \"" + template.description() + "\"\n\tmodel type: \"" + model.getClass() + "\"\n\treflection used: \"" + isReflectiveTemplate + "\"");
        }
        return filter;
    }

    @Override
    public final boolean supportsType(Class<?> modelType) {
        if (TemplateModel.class.isAssignableFrom(modelType)) {
            return true;
        }
        if (Templates.isIgnoredType(modelType)) {
            return false;
        }
        return this.extensions().getTemplateFinder().supportsType(modelType);
    }

    protected TemplateInfo template(Class<?> modelType) {
        try {
            return this.extensions().getTemplateFinder().findTemplate(modelType);
        }
        catch (Exception e) {
            Templates.sneakyThrow(e);
            throw new RuntimeException(e);
        }
    }
}

