/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.spi;

import io.jstach.jstachio.Output;
import io.jstach.jstachio.Template;
import io.jstach.jstachio.TemplateInfo;
import io.jstach.jstachio.spi.BrokenFilter;
import io.jstach.jstachio.spi.CompositeFilterChain;
import io.jstach.jstachio.spi.JStachioExtension;
import io.jstach.jstachio.spi.NoFilter;
import io.jstach.jstachio.spi.Templates;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.eclipse.jdt.annotation.Nullable;

public interface JStachioFilter
extends JStachioExtension {
    public FilterChain filter(TemplateInfo var1, FilterChain var2);

    default public int order() {
        return 0;
    }

    public static JStachioFilter compose(Iterable<JStachioFilter> filters) {
        ArrayList<JStachioFilter> fs = new ArrayList<JStachioFilter>();
        for (JStachioFilter f : filters) {
            fs.add(f);
        }
        if (fs.isEmpty()) {
            return NoFilter.NO_FILTER;
        }
        if (fs.size() == 1) {
            return (JStachioFilter)fs.get(0);
        }
        fs.sort(Comparator.comparingInt(JStachioFilter::order));
        return new CompositeFilterChain(List.copyOf(fs));
    }

    public static interface FilterChain {
        public void process(Object var1, Output<?> var2) throws Exception;

        default public boolean isBroken(Object model) {
            return false;
        }

        public static Template<?> toTemplate(final FilterChain chain, final TemplateInfo templateInfo) {
            if (chain instanceof Template) {
                Template template = (Template)((Object)chain);
                return template;
            }
            return new Template<Object>(){

                @Override
                public String templateName() {
                    return templateInfo.templateName();
                }

                @Override
                public String templatePath() {
                    return templateInfo.templatePath();
                }

                @Override
                public Class<?> templateContentType() {
                    return templateInfo.templateContentType();
                }

                @Override
                public Charset templateCharset() {
                    return templateInfo.templateCharset();
                }

                @Override
                public String templateMediaType() {
                    return templateInfo.templateMediaType();
                }

                @Override
                public Function<String, String> templateEscaper() {
                    return templateInfo.templateEscaper();
                }

                @Override
                public Function<@Nullable Object, String> templateFormatter() {
                    return templateInfo.templateFormatter();
                }

                @Override
                public boolean supportsType(Class<?> type) {
                    return templateInfo.supportsType(type);
                }

                @Override
                public <A extends Output<E>, E extends Exception> A execute(Object model, A appendable) throws E {
                    try {
                        chain.process(model, appendable);
                        return appendable;
                    }
                    catch (Exception e) {
                        Templates.sneakyThrow(e);
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public Class<?> modelClass() {
                    return templateInfo.modelClass();
                }
            };
        }

        public static FilterChain of(JStachioFilter filter, TemplateInfo template) {
            FilterChain previous = BrokenFilter.INSTANCE;
            if (template instanceof FilterChain) {
                FilterChain c = (FilterChain)((Object)template);
                previous = c;
            } else if (template instanceof Template) {
                Template t = (Template)template;
                previous = (model, appendable) -> t.execute(model, appendable);
            }
            return filter.filter(template, previous);
        }
    }
}

