/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio;

import io.jstach.jstachio.Output;
import io.jstach.jstachio.Renderer;
import io.jstach.jstachio.TemplateInfo;
import io.jstach.jstachio.TemplateModel;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public interface Template<T>
extends Renderer<T>,
TemplateInfo {
    @Override
    public <A extends Output<E>, E extends Exception> A execute(T var1, A var2) throws E;

    default public <A extends Output.EncodedOutput<E>, E extends Exception> A write(T model, A output) throws E {
        return this.execute(model, output);
    }

    default public void write(T model, OutputStream outputStream) throws IOException {
        OutputStreamWriter ow = new OutputStreamWriter(outputStream, this.templateCharset());
        this.execute(model, (Output)((Object)ow));
        ow.flush();
    }

    default public TemplateModel model(T model) {
        return TemplateModel.of(this, model);
    }

    public static interface EncodedTemplate<T>
    extends Template<T> {
        @Override
        default public void write(T model, OutputStream outputStream) throws IOException {
            this.write(model, Output.of(outputStream, this.templateCharset()));
        }

        @Override
        public <A extends Output.EncodedOutput<E>, E extends Exception> A write(T var1, A var2) throws E;

        @Override
        default public TemplateModel model(T model) {
            return TemplateModel.of(this, model);
        }
    }
}

