/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.output;

import io.jstach.jstachio.output.ByteBufferEncodedOutput;
import io.jstach.jstachio.output.OutputConsumer;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class ByteBufferedOutputStream
extends OutputStream
implements ByteBufferEncodedOutput {
    public static final int BUFFER_SIZE = 4096;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    protected byte[] buf;
    protected int count;
    protected final Charset charset;

    public ByteBufferedOutputStream(int bufferSize) {
        this(bufferSize, StandardCharsets.UTF_8);
    }

    public ByteBufferedOutputStream(int bufferSize, Charset charset) {
        this.buf = new byte[bufferSize];
        this.charset = charset;
    }

    public ByteBufferedOutputStream() {
        this(4096);
    }

    void reset() {
        this.count = 0;
    }

    @Override
    public void close() {
        this.reset();
    }

    @Override
    public Charset charset() {
        return this.charset;
    }

    @Override
    public void write(byte[] bytes) {
        int len = bytes.length;
        this.ensureCapacity(this.count + len);
        System.arraycopy(bytes, 0, this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public void write(byte[] bytes, int off, int len) {
        this.ensureCapacity(this.count + len);
        System.arraycopy(bytes, off, this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public void append(String s) {
        this.write(s.getBytes(this.charset));
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public byte[] toByteArray() {
        byte[] array = new byte[this.count];
        System.arraycopy(this.buf, 0, array, 0, this.count);
        return array;
    }

    public ByteBuffer toBuffer() {
        return ByteBuffer.wrap(this.buf, 0, this.count);
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return this.toBuffer();
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity - this.buf.length > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.buf.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = ByteBufferedOutputStream.hugeCapacity(minCapacity);
        }
        this.buf = Arrays.copyOf(this.buf, newCapacity);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    @Override
    public void write(int b) {
        throw new UnsupportedOperationException("expecting only write(byte[])");
    }

    @Override
    public void transferTo(OutputStream stream) throws IOException {
        stream.write(this.buf, 0, this.count);
    }

    @Override
    public <E extends Exception> void accept(OutputConsumer<E> consumer) throws E {
        consumer.accept(this.buf, 0, this.count);
    }

    @Override
    public boolean isReusable() {
        return true;
    }
}

