/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.output;

import io.jstach.jstachio.output.LimitEncodedOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;

public abstract class ThresholdEncodedOutput<T, E extends Exception>
implements LimitEncodedOutput<T, E> {
    private final List<byte[]> chunks = new ArrayList<byte[]>();
    private final Charset charset;
    private int size = 0;
    protected final int limit;
    private @Nullable T consumer;

    protected ThresholdEncodedOutput(Charset charset, int limit) {
        this.charset = charset;
        this.limit = limit;
    }

    protected abstract void write(T var1, byte[] var2) throws E;

    protected abstract T createConsumer(int var1) throws E;

    protected abstract void close(T var1) throws E;

    @Override
    public void write(byte[] bytes) throws E {
        this.addChunk(bytes);
    }

    private void addChunk(byte[] chunk) throws E {
        int length = chunk.length;
        @Nullable T c = this.consumer;
        if (c != null) {
            this.write(c, chunk);
        } else if (length + this.size > this.limit) {
            T _consumer = this.createConsumer(-1);
            this.consumer = _consumer;
            this.chunks.add(chunk);
            this.drain(_consumer);
        } else {
            this.chunks.add(chunk);
        }
        this.size += length;
    }

    private void drain(T consumer) throws E {
        for (byte[] chunk : this.chunks) {
            this.write(consumer, chunk);
        }
    }

    @Override
    public @Nullable T consumer() {
        return this.consumer;
    }

    @Override
    public Charset charset() {
        return this.charset;
    }

    @Override
    public void close() throws E {
        T _consumer;
        @Nullable T c = this.consumer;
        if (c == null) {
            this.consumer = _consumer = this.createConsumer(this.size);
            this.drain(_consumer);
        } else {
            _consumer = c;
        }
        this.close(_consumer);
        this.consumer = null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public void append(CharSequence s) throws E {
        this.append(s.toString());
    }

    @Override
    public void append(String s) throws E {
        this.write(s.getBytes(this.charset));
    }

    public static abstract class OutputStreamThresholdEncodedOutput
    extends ThresholdEncodedOutput<OutputStream, IOException> {
        protected OutputStreamThresholdEncodedOutput(Charset charset, int limit) {
            super(charset, limit);
        }

        @Override
        protected void write(OutputStream consumer, byte[] bytes) throws IOException {
            consumer.write(bytes);
        }

        @Override
        protected void close(OutputStream consumer) throws IOException {
            consumer.close();
        }
    }
}

