/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.spi;

import io.jstach.jstachio.TemplateInfo;
import io.jstach.jstachio.spi.JStachioTemplateFinder;
import io.jstach.jstachio.spi.Templates;
import java.util.Objects;

final class ClassValueCacheTemplateFinder
implements JStachioTemplateFinder {
    private final ClassValue<TemplateInfo> cache;
    private final JStachioTemplateFinder delegate;

    public ClassValueCacheTemplateFinder(final JStachioTemplateFinder delegate) {
        this.delegate = delegate;
        this.cache = new ClassValue<TemplateInfo>(){

            @Override
            protected TemplateInfo computeValue(Class<?> type) {
                try {
                    return delegate.findTemplate(type);
                }
                catch (Exception e) {
                    Templates.sneakyThrow(e);
                    throw new RuntimeException();
                }
            }
        };
    }

    @Override
    public TemplateInfo findTemplate(Class<?> modelType) throws Exception {
        Objects.requireNonNull(modelType);
        return Objects.requireNonNull(this.cache.get(modelType));
    }

    @Override
    public int order() {
        return this.delegate.order();
    }
}

