/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.spi;

import io.jstach.jstachio.TemplateInfo;
import io.jstach.jstachio.spi.JStachioTemplateFinder;
import io.jstach.jstachio.spi.TemplateNotFoundException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

final class CompositeTemplateFinder
implements JStachioTemplateFinder {
    private final Iterable<? extends JStachioTemplateFinder> finders;

    private CompositeTemplateFinder(Iterable<? extends JStachioTemplateFinder> finders) {
        this.finders = finders;
    }

    public static JStachioTemplateFinder of(List<? extends JStachioTemplateFinder> finders) {
        if (finders.size() == 1) {
            return finders.get(0);
        }
        ArrayList<? extends JStachioTemplateFinder> sorted = new ArrayList<JStachioTemplateFinder>();
        sorted.addAll(finders);
        sorted.sort(Comparator.comparingInt(JStachioTemplateFinder::order));
        return new CompositeTemplateFinder(List.copyOf(sorted));
    }

    @Override
    public TemplateInfo findTemplate(Class<?> modelType) throws Exception {
        for (JStachioTemplateFinder jStachioTemplateFinder : this.finders) {
            TemplateInfo t = jStachioTemplateFinder.findOrNull(modelType);
            if (t == null) continue;
            return t;
        }
        throw new TemplateNotFoundException(modelType);
    }

    @Override
    public boolean supportsType(Class<?> modelType) {
        for (JStachioTemplateFinder jStachioTemplateFinder : this.finders) {
            boolean b = jStachioTemplateFinder.supportsType(modelType);
            if (!b) continue;
            return true;
        }
        return false;
    }
}

