/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.spi;

import io.jstach.jstachio.JStachio;
import io.jstach.jstachio.TemplateInfo;
import io.jstach.jstachio.spi.AbstractJStachio;
import io.jstach.jstachio.spi.DefaultJStachio;
import io.jstach.jstachio.spi.JStachioExtension;
import io.jstach.jstachio.spi.JStachioExtensions;
import io.jstach.jstachio.spi.JStachioTemplateFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class JStachioFactory {
    private JStachioFactory() {
    }

    public static JStachio defaultJStachio() {
        return Holder.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static class Holder
    extends AbstractJStachio {
        private static final Holder INSTANCE = Holder.of();
        private final JStachioExtensions extensions;

        public Holder(JStachioExtensions extensions) {
            this.extensions = extensions;
        }

        private static Holder of() {
            return new Holder(JStachioExtensions.of());
        }

        @Override
        public JStachioExtensions extensions() {
            return this.extensions;
        }

        public String toString() {
            return "ServiceLoaderJStachio";
        }
    }

    public static class Builder {
        private List<JStachioExtension> extensions = new ArrayList<JStachioExtension>();
        private List<TemplateInfo> templates = new ArrayList<TemplateInfo>();

        private Builder() {
        }

        public Builder add(JStachioExtension extension) {
            this.extensions.add(extension);
            return this;
        }

        public Builder add(Iterable<? extends JStachioExtension> extensions) {
            extensions.forEach(this.extensions::add);
            return this;
        }

        public Builder add(TemplateInfo template) {
            Objects.requireNonNull(template, "template");
            this.templates.add(template);
            return this;
        }

        public Builder add(Collection<? extends TemplateInfo> templates) {
            this.templates.addAll(templates);
            return this;
        }

        public JStachio build() {
            ArrayList<JStachioExtension> resolved = new ArrayList<JStachioExtension>();
            if (!this.templates.isEmpty()) {
                List<TemplateInfo> templatesCopy = List.copyOf(this.templates);
                JStachioTemplateFinder f = JStachioTemplateFinder.of(templatesCopy, -1);
                f = JStachioTemplateFinder.cachedTemplateFinder(f);
                resolved.add(f);
            }
            resolved.addAll(this.extensions);
            return new DefaultJStachio(JStachioExtensions.of(resolved));
        }
    }
}

