/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio;

import java.nio.charset.Charset;
import java.util.function.Function;
import org.eclipse.jdt.annotation.Nullable;

public interface TemplateInfo {
    public static final String TEMPLATE_BINDING_NAME = "@template";

    public String templateName();

    public String templatePath();

    default public String normalizePath() {
        String p = this.templatePath();
        if (p.startsWith("/")) {
            return p.substring(1);
        }
        return p;
    }

    default public String templateString() {
        return "";
    }

    public Class<?> templateContentType();

    public Charset templateCharset();

    public String templateMediaType();

    public Function<String, String> templateEscaper();

    public Function<@Nullable Object, String> templateFormatter();

    public boolean supportsType(Class<?> var1);

    public Class<?> modelClass();

    default public TemplateSource templateSource() {
        return this.templatePath().isEmpty() ? TemplateSource.STRING : TemplateSource.RESOURCE;
    }

    default public long lastLoaded() {
        return -1L;
    }

    default public String description() {
        return String.format("TemplateInfo[name=%s, path=%s, contentType=%s, charset=%s]", this.templateName(), this.templatePath(), this.templateContentType(), this.templateCharset());
    }

    public static enum TemplateSource {
        RESOURCE,
        STRING;

    }
}

