/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio;

import io.jstach.jstachio.DefaultTemplateExecutable;
import io.jstach.jstachio.EncodedTemplateExecutable;
import io.jstach.jstachio.Output;
import io.jstach.jstachio.Template;
import java.io.IOException;
import java.io.OutputStream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface TemplateModel {
    public Template<?> template();

    public Object model();

    public <A extends Output<E>, E extends Exception> A execute(A var1) throws E;

    default public <A extends Output.EncodedOutput<E>, E extends Exception> A write(A output) throws E {
        return this.execute(output);
    }

    default public void write(OutputStream outputStream) throws IOException {
        this.write(Output.of(outputStream, this.template().templateCharset()));
    }

    default public String execute() {
        return this.execute(Output.of(new StringBuilder())).getBuffer().toString();
    }

    public static <T> TemplateModel of(Template.EncodedTemplate<T> template, T model) {
        return new EncodedTemplateExecutable<T>(template, model);
    }

    public static <T> TemplateModel of(Template<T> template, T model) {
        if (template instanceof Template.EncodedTemplate) {
            Template.EncodedTemplate et = (Template.EncodedTemplate)template;
            return TemplateModel.of(et, model);
        }
        return new DefaultTemplateExecutable<T>(template, model);
    }
}

