/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.context;

import io.jstach.jstachio.Output;
import io.jstach.jstachio.context.ContextNode;
import io.jstach.jstachio.context.ContextSupplier;
import io.jstach.jstachio.output.ForwardingEncodedOutput;
import io.jstach.jstachio.output.ForwardingOutput;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
interface ContextAwareOutput<O>
extends ContextSupplier {
    public O getOutput();

    public static <E extends Exception, O extends Output<E>> ContextOutput<E, O> of(O output, ContextNode context) {
        return new ContextOutput(output, context);
    }

    public static <E extends Exception, O extends Output.EncodedOutput<E>> ContextEncodedOutput<E, O> of(O output, ContextNode context) {
        return new ContextEncodedOutput(output, context);
    }

    public static final class ContextOutput<E extends Exception, O extends Output<E>>
    extends ForwardingOutput<E>
    implements ContextAwareOutput<O> {
        private final O output;
        private final ContextNode context;

        private ContextOutput(O output, ContextNode context) {
            this.output = output;
            this.context = context;
        }

        @Override
        public ContextNode context() {
            return this.context;
        }

        protected O delegate() {
            return this.output;
        }

        @Override
        public O getOutput() {
            return this.output;
        }
    }

    public static final class ContextEncodedOutput<E extends Exception, O extends Output.EncodedOutput<E>>
    extends ForwardingEncodedOutput<E>
    implements ContextAwareOutput<O> {
        private final O output;
        private final ContextNode context;

        private ContextEncodedOutput(O output, ContextNode context) {
            this.output = output;
            this.context = context;
        }

        @Override
        public ContextNode context() {
            return this.context;
        }

        protected O delegate() {
            return this.output;
        }

        @Override
        public O getOutput() {
            return this.output;
        }
    }
}

