/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.output;

import io.jstach.jstachio.Output;
import io.jstach.jstachio.output.AbstractLimitEncodedOutput;
import io.jstach.jstachio.output.ChunkEncodedOutput;
import io.jstach.jstachio.output.LimitEncodedOutput;
import io.jstach.jstachio.output.OutputConsumer;
import io.jstach.jstachio.output.OutputFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface BufferedEncodedOutput
extends Output.CloseableEncodedOutput<RuntimeException> {
    public int size();

    default public void transferTo(OutputStream stream) throws IOException {
        this.accept(stream::write);
    }

    default public LimitEncodedOutput<OutputStream, IOException> limit(int limit, final OutputFactory<OutputStream, IOException> factory) {
        return new AbstractLimitEncodedOutput(this, limit){

            @Override
            protected OutputStream createConsumer(int size) throws IOException {
                return (OutputStream)factory.create(size);
            }
        };
    }

    public <E extends Exception> void accept(OutputConsumer<E> var1) throws E;

    default public int bufferSizeHint() {
        return this.size();
    }

    public ReadableByteChannel asReadableByteChannel();

    default public byte[] toByteArray() {
        int size = this.size();
        final byte[] result = new byte[size];
        OutputConsumer<RuntimeException> consumer = new OutputConsumer<RuntimeException>(){
            int index = 0;

            @Override
            public void accept(byte[] data, int offset, int length) throws RuntimeException {
                System.arraycopy(data, offset, result, this.index, length);
                this.index += length;
            }
        };
        this.accept(consumer);
        return result;
    }

    @Override
    default public void append(String s) {
        this.write(s.getBytes(this.charset()));
    }

    @Override
    default public void append(CharSequence s) {
        this.append(s.toString());
    }

    @Override
    public void close();

    default public boolean isReusable() {
        return false;
    }

    public static BufferedEncodedOutput ofChunked(Charset charset) {
        return ChunkEncodedOutput.ofByteArrays(charset);
    }
}

