/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.output;

import io.jstach.jstachio.output.BufferedEncodedOutput;
import io.jstach.jstachio.output.ByteBufferChannel;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.Nullable;

interface BufferedReadableByteChannel
extends ReadableByteChannel {
    @Override
    public int read(ByteBuffer var1);

    @Override
    public void close();

    public int size();

    public static BufferedReadableByteChannel of(BufferedEncodedOutput output, ByteBuffer buffer) {
        return new ByteBufferChannel(buffer, output);
    }

    public static BufferedReadableByteChannel of(final BufferedEncodedOutput output, final List<byte[]> arrays) {
        final int length = output.size();
        return new BufferedReadableByteChannel(){
            private boolean closed = false;
            private int offset = 0;
            private int chunkIndex = 0;
            private int chunkOffset = 0;

            @Override
            public int read(ByteBuffer dst) {
                if (arrays.isEmpty() || this.offset >= length) {
                    return -1;
                }
                int readBytes = 0;
                while (dst.hasRemaining() && this.offset < length) {
                    byte[] chunk = (byte[])arrays.get(this.chunkIndex);
                    int chunkLength = chunk.length - this.chunkOffset;
                    int capacity = dst.remaining();
                    if (capacity < chunkLength) {
                        chunkLength = capacity;
                    }
                    dst.put(chunk, this.chunkOffset, chunkLength);
                    this.offset += chunkLength;
                    this.chunkOffset += chunkLength;
                    if (this.chunkOffset >= chunk.length) {
                        ++this.chunkIndex;
                        this.chunkOffset = 0;
                    }
                    readBytes += chunkLength;
                }
                return readBytes;
            }

            @Override
            public boolean isOpen() {
                return !this.closed;
            }

            @Override
            public int size() {
                return length;
            }

            @Override
            public void close() {
                this.closed = true;
                output.close();
            }
        };
    }

    public static BufferedReadableByteChannel of(BufferedEncodedOutput output, Iterator<byte[]> arrays) {
        Supplier<byte @Nullable []> sup = () -> {
            if (!arrays.hasNext()) {
                return null;
            }
            return (byte[])arrays.next();
        };
        return BufferedReadableByteChannel.of(output, sup);
    }

    public static BufferedReadableByteChannel of(final BufferedEncodedOutput output, final Supplier<byte @Nullable []> arrays) {
        final int length = output.size();
        return new BufferedReadableByteChannel(){
            private boolean closed = false;
            private int chunkOffset = 0;
            byte @Nullable [] current = (byte[])arrays.get();

            @Override
            public int read(ByteBuffer dst) {
                if (this.current == null) {
                    return -1;
                }
                int readBytes = 0;
                while (true) {
                    byte[] chunk = this.current;
                    if (this.current == null || !dst.hasRemaining()) break;
                    int chunkLength = chunk.length - this.chunkOffset;
                    int capacity = dst.remaining();
                    if (capacity < chunkLength) {
                        chunkLength = capacity;
                    }
                    dst.put(chunk, this.chunkOffset, chunkLength);
                    this.chunkOffset += chunkLength;
                    if (this.chunkOffset >= chunk.length) {
                        this.current = (byte[])arrays.get();
                        this.chunkOffset = 0;
                    }
                    readBytes += chunkLength;
                }
                return readBytes;
            }

            @Override
            public boolean isOpen() {
                return !this.closed;
            }

            @Override
            public int size() {
                return length;
            }

            @Override
            public void close() {
                this.closed = true;
                output.close();
            }
        };
    }
}

