/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.spi;

import io.jstach.jstachio.TemplateInfo;
import io.jstach.jstachio.spi.ExceptionTemplateInfo;
import io.jstach.jstachio.spi.JStachioTemplateFinder;
import io.jstach.jstachio.spi.TemplateNotFoundException;
import io.jstach.jstachio.spi.Templates;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;

final class ClassValueCacheTemplateFinder
implements JStachioTemplateFinder {
    private final ClassValue<TemplateInfo> cache;
    private final JStachioTemplateFinder delegate;

    public ClassValueCacheTemplateFinder(final JStachioTemplateFinder delegate) {
        this.delegate = delegate;
        this.cache = new ClassValue<TemplateInfo>(){

            @Override
            protected TemplateInfo computeValue(Class<?> type) {
                try {
                    return delegate.findTemplate(type);
                }
                catch (TemplateNotFoundException e) {
                    return new ExceptionTemplateInfo(e);
                }
                catch (Exception e) {
                    Templates.sneakyThrow(e);
                    throw new RuntimeException();
                }
            }
        };
    }

    @Override
    public TemplateInfo findTemplate(Class<?> modelType) throws Exception {
        Objects.requireNonNull(modelType, "modelType");
        if (Templates.isIgnoredType(modelType)) {
            throw new TemplateNotFoundException(modelType);
        }
        TemplateInfo info = this.cache.get(modelType);
        if (info instanceof ExceptionTemplateInfo) {
            ExceptionTemplateInfo et = (ExceptionTemplateInfo)info;
            throw et.exception();
        }
        return Objects.requireNonNull(info);
    }

    @Override
    public @Nullable TemplateInfo findOrNull(Class<?> modelType) {
        Objects.requireNonNull(modelType, "modelType");
        if (Templates.isIgnoredType(modelType)) {
            return null;
        }
        try {
            TemplateInfo info = this.cache.get(modelType);
            if (info instanceof ExceptionTemplateInfo) {
                ExceptionTemplateInfo et = (ExceptionTemplateInfo)info;
                return null;
            }
            return info;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public int order() {
        return this.delegate.order();
    }
}

