/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.spi;

import io.jstach.jstachio.TemplateInfo;
import io.jstach.jstachio.spi.JStachioTemplateFinder;
import io.jstach.jstachio.spi.TemplateNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;

final class CompositeTemplateFinder
implements JStachioTemplateFinder {
    private final Iterable<? extends JStachioTemplateFinder> finders;

    private CompositeTemplateFinder(Iterable<? extends JStachioTemplateFinder> finders) {
        this.finders = finders;
    }

    public static JStachioTemplateFinder of(List<? extends JStachioTemplateFinder> finders) {
        if (finders.size() == 1) {
            return finders.get(0);
        }
        ArrayList<? extends JStachioTemplateFinder> sorted = new ArrayList<JStachioTemplateFinder>();
        sorted.addAll(finders);
        sorted.sort(Comparator.comparingInt(JStachioTemplateFinder::order));
        ArrayList<JStachioTemplateFinder> flatten = new ArrayList<JStachioTemplateFinder>();
        Set found = Collections.newSetFromMap(new IdentityHashMap());
        for (JStachioTemplateFinder jStachioTemplateFinder : sorted) {
            if (jStachioTemplateFinder instanceof CompositeTemplateFinder) {
                CompositeTemplateFinder ctf = (CompositeTemplateFinder)jStachioTemplateFinder;
                for (JStachioTemplateFinder jStachioTemplateFinder2 : ctf.finders) {
                    if (!found.add(jStachioTemplateFinder2)) continue;
                    flatten.add(jStachioTemplateFinder2);
                }
                continue;
            }
            if (!found.add(jStachioTemplateFinder)) continue;
            flatten.add(jStachioTemplateFinder);
        }
        if (flatten.size() == 1) {
            return (JStachioTemplateFinder)flatten.get(0);
        }
        return new CompositeTemplateFinder(List.copyOf(flatten));
    }

    @Override
    public TemplateInfo findTemplate(Class<?> modelType) throws Exception {
        for (JStachioTemplateFinder jStachioTemplateFinder : this.finders) {
            TemplateInfo t = jStachioTemplateFinder.findOrNull(modelType);
            if (t == null) continue;
            return t;
        }
        throw new TemplateNotFoundException(modelType);
    }

    @Override
    public boolean supportsType(Class<?> modelType) {
        for (JStachioTemplateFinder jStachioTemplateFinder : this.finders) {
            boolean b = jStachioTemplateFinder.supportsType(modelType);
            if (!b) continue;
            return true;
        }
        return false;
    }
}

