/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.spi;

import io.jstach.jstachio.TemplateInfo;
import io.jstach.jstachio.spi.ClassValueCacheTemplateFinder;
import io.jstach.jstachio.spi.CompositeTemplateFinder;
import io.jstach.jstachio.spi.DefaultTemplateFinder;
import io.jstach.jstachio.spi.IterableTemplateFinder;
import io.jstach.jstachio.spi.JStachioConfig;
import io.jstach.jstachio.spi.JStachioExtension;
import io.jstach.jstachio.spi.TemplateNotFoundException;
import io.jstach.jstachio.spi.Templates;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;

public interface JStachioTemplateFinder
extends JStachioExtension {
    public TemplateInfo findTemplate(Class<?> var1) throws Exception;

    default public @Nullable TemplateInfo findOrNull(Class<?> modelType) {
        Objects.requireNonNull(modelType, "modelType");
        if (Templates.isIgnoredType(modelType)) {
            return null;
        }
        try {
            return this.findTemplate(modelType);
        }
        catch (Exception e) {
            return null;
        }
    }

    default public boolean supportsType(Class<?> modelType) {
        if (Templates.isIgnoredType(modelType)) {
            return false;
        }
        TemplateInfo t = this.findOrNull(modelType);
        return t != null;
    }

    default public int order() {
        return 0;
    }

    public static JStachioTemplateFinder defaultTemplateFinder(JStachioConfig config) {
        return new DefaultTemplateFinder(config);
    }

    public static JStachioTemplateFinder cachedTemplateFinder(JStachioTemplateFinder finder) {
        if (finder instanceof ClassValueCacheTemplateFinder) {
            return finder;
        }
        return new ClassValueCacheTemplateFinder(finder);
    }

    public static JStachioTemplateFinder of(Iterable<? extends TemplateInfo> templates, int order) {
        return new IterableTemplateFinder(templates, order);
    }

    public static JStachioTemplateFinder of(List<? extends JStachioTemplateFinder> templateFinders) {
        return CompositeTemplateFinder.of(templateFinders);
    }

    public static interface SimpleTemplateFinder
    extends JStachioTemplateFinder {
        @Override
        default public TemplateInfo findTemplate(Class<?> modelType) throws Exception {
            Objects.requireNonNull(modelType, "modelType");
            TemplateInfo t = this.findOrNull(modelType);
            if (t == null) {
                throw new TemplateNotFoundException(modelType);
            }
            return t;
        }

        @Override
        default public boolean supportsType(Class<?> modelType) {
            Objects.requireNonNull(modelType, "modelType");
            TemplateInfo t = this.findOrNull(modelType);
            return t != null;
        }

        @Override
        default public @Nullable TemplateInfo findOrNull(Class<?> modelType) {
            Class<?> resolvedType = Templates.findJStache(modelType).getKey();
            for (TemplateInfo templateInfo : this.templates()) {
                if (!templateInfo.supportsType(resolvedType)) continue;
                return templateInfo;
            }
            return null;
        }

        public Iterable<? extends TemplateInfo> templates();
    }
}

