/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.spi;

import io.jstach.jstache.JStache;
import io.jstach.jstache.JStacheConfig;
import io.jstach.jstache.JStacheContentType;
import io.jstach.jstache.JStacheFormatter;
import io.jstach.jstache.JStacheName;
import io.jstach.jstache.JStachePath;
import io.jstach.jstachio.Output;
import io.jstach.jstachio.Template;
import io.jstach.jstachio.TemplateConfig;
import io.jstach.jstachio.TemplateInfo;
import io.jstach.jstachio.escapers.Html;
import io.jstach.jstachio.escapers.PlainText;
import io.jstach.jstachio.formatters.DefaultFormatter;
import io.jstach.jstachio.formatters.SpecFormatter;
import io.jstach.jstachio.spi.JStachioConfig;
import io.jstach.jstachio.spi.TemplateNotFoundException;
import io.jstach.jstachio.spi.TemplateProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.jdt.annotation.Nullable;

public final class Templates {
    private static final Set<TemplateLoadStrategy> ALL_STRATEGIES = EnumSet.allOf(TemplateLoadStrategy.class);

    private Templates() {
    }

    public static void validateEncoding(TemplateInfo template, Output.EncodedOutput<?> output) {
        if (!template.templateCharset().equals(output.charset())) {
            throw new UnsupportedCharsetException("The encoding of the template does not match the output. template charset=" + template.templateCharset() + ", output charset=" + output.charset());
        }
    }

    public static TemplateInfo findTemplate(Class<?> modelType, JStachioConfig config) throws Exception {
        System.Logger logger = config.getLogger(Templates.class.getName());
        return Templates.findTemplate(modelType, config, logger);
    }

    public static @Nullable TemplateInfo findTemplateOrNull(Class<?> modelType, JStachioConfig config) {
        if (Templates.isIgnoredType(modelType)) {
            return null;
        }
        try {
            return Templates.findTemplate(modelType, config, JStachioConfig.noopLogger());
        }
        catch (Exception e) {
            return null;
        }
    }

    static boolean isIgnoredType(Class<?> modelType) {
        if (modelType == String.class || modelType == Map.class || modelType == Object.class || modelType.isPrimitive()) {
            return true;
        }
        return modelType.getName().startsWith("java.");
    }

    static Map.Entry<Class<?>, JStache> findJStache(Class<?> modelType) {
        Map.Entry<Class<?>, JStache> jstache = Templates.findJStacheOrNull(modelType);
        if (jstache == null) {
            throw new TemplateNotFoundException("JStache annotation was not found on type or parents.", modelType);
        }
        return jstache;
    }

    static @Nullable Map.Entry<Class<?>, JStache> findJStacheOrNull(Class<?> modelType) {
        if (Templates.isIgnoredType(modelType)) {
            return null;
        }
        return Templates.possibleJStacheTypes(modelType).flatMap(_c -> Stream.ofNullable(_c.getDeclaredAnnotation(JStache.class)).map(a -> Map.entry(_c, a))).findFirst().orElse(null);
    }

    private static Stream<Class<?>> possibleJStacheTypes(Class<?> modelType) {
        if (Templates.isIgnoredType(modelType)) {
            return Stream.empty();
        }
        return Stream.concat(Templates.parents(modelType), Templates.interfaces(modelType)).filter(_c -> !Templates.isIgnoredType(_c));
    }

    static TemplateInfo findTemplate(Class<?> modelType, JStachioConfig config, System.Logger logger) throws Exception {
        Exception error;
        Exception firstError;
        EnumSet<TemplateLoadStrategy> strategies = EnumSet.noneOf(TemplateLoadStrategy.class);
        for (TemplateLoadStrategy s : ALL_STRATEGIES) {
            if (!s.isEnabled(config)) continue;
            strategies.add(s);
        }
        List<ClassLoader> classLoaders = Templates.collectClassLoaders(modelType.getClassLoader());
        if (config.getBoolean("jstachio.reflection.template.disable")) {
            List<Class<?>> resolvedTypes = Templates.possibleJStacheTypes(modelType).toList();
            firstError = null;
            for (Class<?> resolvedType : resolvedTypes) {
                try {
                    return Templates.getTemplate(resolvedType, strategies, classLoaders, logger);
                }
                catch (Exception e) {
                    if (firstError != null) continue;
                    firstError = e;
                }
            }
        } else {
            Class<?> resolvedType = Templates.findJStache(modelType).getKey();
            try {
                return Templates.getTemplate(resolvedType, strategies, classLoaders, logger);
            }
            catch (Exception e) {
                error = e;
                if (logger.isLoggable(System.Logger.Level.WARNING)) {
                    String message = String.format("Could not find generated template and will try reflection for model type:'%s', annotated type: '%s'", modelType, resolvedType);
                    logger.log(System.Logger.Level.WARNING, message, (Throwable)error);
                }
                return Templates.getInfoByReflection(resolvedType);
            }
        }
        error = firstError != null ? firstError : new TemplateNotFoundException(modelType, strategies);
        throw error;
    }

    public static TemplateInfo getInfoByReflection(Class<?> modelType) throws Exception {
        return TemplateInfos.templateOf(modelType);
    }

    public static <T> Template<T> getTemplate(Class<T> clazz) throws Exception {
        List<ClassLoader> classLoaders = Templates.collectClassLoaders(clazz.getClassLoader());
        return Templates.getTemplate(clazz, ALL_STRATEGIES, classLoaders, JStachioConfig.noopLogger());
    }

    public static <T> Template<T> getTemplate(Class<T> modelType, Iterable<TemplateLoadStrategy> strategies, Iterable<ClassLoader> classLoaders, System.Logger logger) throws Exception {
        for (TemplateLoadStrategy s : strategies) {
            if (logger.isLoggable(System.Logger.Level.DEBUG)) {
                logger.log(System.Logger.Level.DEBUG, "For modelType: \"" + modelType + "\" trying strategy: \"" + s + "\"");
            }
            for (ClassLoader classLoader : classLoaders) {
                try {
                    Template<T> template = s.load(modelType, classLoader, logger);
                    if (template == null) continue;
                    return template;
                }
                catch (TemplateNotFoundException | ClassNotFoundException e) {
                }
            }
        }
        throw new TemplateNotFoundException(modelType, StreamSupport.stream(strategies.spliterator(), false).toList());
    }

    static boolean isReflectionTemplate(TemplateInfo template) {
        if (template instanceof TemplateInfos.SimpleTemplateInfo) {
            TemplateInfos.SimpleTemplateInfo si = (TemplateInfos.SimpleTemplateInfo)template;
            return true;
        }
        return false;
    }

    private static <T> @Nullable Template<T> templateByConstructor(Class<T> clazz, ClassLoader classLoader) throws Exception {
        Class<?> implementation = classLoader.loadClass(Templates.generatedClassName(clazz));
        Constructor<?> constructor = implementation.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        return (Template)constructor.newInstance(new Object[0]);
    }

    public static String generatedClassName(Class<?> modelClass) {
        Object cname;
        JStache a = modelClass.getAnnotation(JStache.class);
        if (a == null) {
            throw new TemplateNotFoundException(modelClass);
        }
        if (a.name().isBlank()) {
            JStacheName name = Templates.findAnnotations(modelClass, JStacheConfig.class).flatMap(config -> Arrays.stream(config.naming())).findFirst().orElse(null);
            String prefix = name == null ? "*" : name.prefix();
            String suffix = name == null ? "*" : name.suffix();
            prefix = prefix.equals("*") ? "" : prefix;
            suffix = suffix.equals("*") ? "Renderer" : suffix;
            cname = prefix + modelClass.getSimpleName() + suffix;
        } else {
            cname = a.name();
        }
        String packageName = modelClass.getPackageName();
        String fqn = packageName + (packageName.isEmpty() ? "" : ".") + (String)cname;
        return fqn;
    }

    private static Charset resolveCharset(Class<?> c) {
        String charset = Templates.findAnnotations(c, JStacheConfig.class).map(config -> config.charset()).filter(cs -> !cs.isEmpty()).findFirst().orElse(null);
        if (charset == null) {
            return StandardCharsets.UTF_8;
        }
        return Charset.forName(charset);
    }

    static <A extends Annotation> Stream<A> findAnnotations(Class<?> c, Class<A> annotationClass) {
        Stream<? extends AnnotatedElement> s = Templates.annotationElements(c);
        return s.filter(p -> p != null).flatMap(p -> Stream.ofNullable(p.getAnnotation(annotationClass)));
    }

    private static Stream<? extends AnnotatedElement> annotationElements(Class<?> c) {
        Stream enclosing = Templates.enclosing(c).flatMap(Templates::expandUsing);
        return Stream.builder().add(enclosing).add(Stream.ofNullable(c.getPackage())).add(Stream.ofNullable(c.getModule())).build().flatMap(Function.identity());
    }

    private static Stream<Class<?>> expandUsing(Class<?> e) {
        JStacheConfig config = e.getAnnotation(JStacheConfig.class);
        if (config == null) {
            return Stream.of(e);
        }
        Class using = config.using();
        if (!using.equals(Void.TYPE)) {
            return Stream.of(e, using);
        }
        return Stream.of(e);
    }

    private static Stream<Class<?>> enclosing(Class<?> e) {
        return Templates.findClasses(e, Class::getEnclosingClass);
    }

    private static Stream<Class<?>> parents(Class<?> e) {
        return Templates.findClasses(e, Class::getSuperclass);
    }

    private static Stream<Class<?>> interfaces(Class<?> clazz) {
        return Stream.concat(Stream.of(clazz.getInterfaces()), Stream.of(clazz.getInterfaces()).flatMap(interfaceClass -> Templates.interfaces(interfaceClass)));
    }

    private static Stream<Class<?>> findClasses(final Class<?> e, final Function<Class<?>, @Nullable Class<?>> f) {
        Spliterators.AbstractSpliterator split = new Spliterators.AbstractSpliterator<Class<?>>(Long.MAX_VALUE, 0){
            @Nullable Class<?> current;
            {
                super(arg0, arg1);
                this.current = e;
            }

            @Override
            public boolean tryAdvance(Consumer<? super Class<?>> action) {
                Class<?> c = this.current;
                if (c == null) {
                    return false;
                }
                this.current = (Class)f.apply(c);
                action.accept(c);
                return true;
            }
        };
        return StreamSupport.stream(split, false);
    }

    private static <T> @Nullable Template<?> templateByServiceLoader(Class<T> clazz, ClassLoader classLoader, System.Logger logger) {
        ServiceLoader<TemplateProvider> loader = ServiceLoader.load(TemplateProvider.class, classLoader);
        return Templates.findTemplates(loader, TemplateConfig.empty(), e -> logger.log(System.Logger.Level.ERROR, "Template provider failed to load. Skipping it.", (Throwable)e)).filter(t -> clazz.equals(t.modelClass())).findFirst().orElse(null);
    }

    public static Stream<Template<?>> findTemplates(ServiceLoader<TemplateProvider> serviceLoader, TemplateConfig templateConfig, Consumer<ServiceConfigurationError> errorHandler) {
        return serviceLoader.stream().flatMap(p -> {
            try {
                return ((TemplateProvider)p.get()).provideTemplates().stream();
            }
            catch (ServiceConfigurationError e) {
                errorHandler.accept(e);
                return Stream.empty();
            }
        });
    }

    private static List<ClassLoader> collectClassLoaders(@Nullable ClassLoader classLoader) {
        return Stream.builder().add(classLoader).add(Thread.currentThread().getContextClassLoader()).add(Template.class.getClassLoader()).build().flatMap(s -> Stream.ofNullable(s)).toList();
    }

    static <E extends Throwable> void sneakyThrow(Throwable x) throws E {
        throw x;
    }

    @Deprecated
    public static @Nullable JStachePath resolvePath(Class<?> model) {
        return Templates._resolvePath(model);
    }

    public static PathInfo getPathInfo(Class<?> modelClass) {
        return DefaultPathInfo.of(modelClass, Templates._resolvePath(modelClass));
    }

    private static @Nullable JStachePath _resolvePath(Class<?> model) {
        return Templates.annotationElements(model).flatMap(e -> TemplateInfos.resolvePathOnElement(e).stream()).findFirst().orElse(null);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum TemplateLoadStrategy {
        SERVICE_LOADER{

            @Override
            protected <T> @Nullable Template<T> load(Class<T> clazz, ClassLoader classLoader, System.Logger logger) throws Exception {
                return Templates.templateByServiceLoader(clazz, classLoader, logger);
            }

            @Override
            protected final boolean isEnabled(JStachioConfig config) {
                return !config.getBoolean("jstachio.serviceloader.template.disable");
            }
        }
        ,
        CONSTRUCTOR{

            @Override
            protected <T> @Nullable Template<T> load(Class<T> clazz, ClassLoader classLoader, System.Logger logger) throws Exception {
                return Templates.templateByConstructor(clazz, classLoader);
            }

            @Override
            protected final boolean isEnabled(JStachioConfig config) {
                return !config.getBoolean("jstachio.reflection.template.disable");
            }
        };


        protected abstract <T> @Nullable Template<T> load(Class<T> var1, ClassLoader var2, System.Logger var3) throws Exception;

        protected abstract boolean isEnabled(JStachioConfig var1);
    }

    static class TemplateInfos {
        TemplateInfos() {
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public static TemplateInfo templateOf(Class<?> model) throws Exception {
            String templatePath;
            JStache stache = model.getAnnotation(JStache.class);
            if (stache == null) {
                throw new IllegalArgumentException("Model class is not annotated with " + JStache.class.getSimpleName() + ". class: " + model);
            }
            String templateString = stache.template();
            String templateName = Templates.generatedClassName(model);
            if (!templateString.isEmpty()) {
                templatePath = "";
            } else {
                PathInfo pathInfo = Templates.getPathInfo(model);
                templatePath = pathInfo.resolveFullPath(Objects.requireNonNull(stache.path()));
            }
            Map.Entry ee = EscaperProvider.INSTANCE.providesFromModelType(model, stache);
            Function templateEscaper = (Function)ee.getValue();
            Class<?> templateContentType = ee.getKey();
            String templateMediaType = "";
            JStacheContentType jstacheContentType = templateContentType.getAnnotation(JStacheContentType.class);
            if (jstacheContentType != null) {
                templateMediaType = Objects.requireNonNull(jstacheContentType.mediaType());
            }
            @Nullable Function templateFormatter = (Function)FormatterProvider.INSTANCE.providesFromModelType(model, stache).getValue();
            Charset templateCharset = Templates.resolveCharset(model);
            long lastLoaded = System.currentTimeMillis();
            return new SimpleTemplateInfo(templateName, templatePath, templateCharset, templateMediaType, templateString, templateContentType, templateEscaper, templateFormatter, lastLoaded, model);
        }

        private static Optional<JStachePath> resolvePathOnElement(AnnotatedElement a) {
            JStachePath path = a.getAnnotation(JStachePath.class);
            if (path != null) {
                return Optional.of(path);
            }
            JStacheConfig config = a.getAnnotation(JStacheConfig.class);
            if (config != null && config.pathing().length > 0) {
                return Optional.ofNullable(config.pathing()[0]);
            }
            return Optional.empty();
        }

        static enum EscaperProvider implements StaticProvider<Function<String, String>>
        {
            INSTANCE;


            @Override
            public Class<?> autoProvider() {
                return JStacheContentType.UnspecifiedContentType.class;
            }

            @Override
            public Class<?> defaultProvider() {
                return Html.class;
            }

            @Override
            public @Nullable Class<?> providerFromJStache(JStache jstache) {
                return null;
            }

            @Override
            public Class<?> providerFromConfig(JStacheConfig config) {
                return Objects.requireNonNull(config.contentType());
            }

            @Override
            public String providesMethod(Class<?> type) {
                JStacheContentType a = type.getAnnotation(JStacheContentType.class);
                if (a == null) {
                    throw new IllegalArgumentException("Specified content type class is not annotated with @" + JStacheContentType.class.getSimpleName());
                }
                return Objects.requireNonNull(a.providesMethod());
            }

            @Override
            public Function<String, String> provides(@Nullable Class<?> contentType) throws Exception {
                if ((contentType = this.nullToDefault(contentType)).equals(Html.class)) {
                    return Html.provider();
                }
                if (contentType.equals(PlainText.class)) {
                    return PlainText.provider();
                }
                return (Function)StaticProvider.super.provides(contentType);
            }
        }

        static enum FormatterProvider implements StaticProvider<Function<Object, String>>
        {
            INSTANCE;


            @Override
            public Class<?> autoProvider() {
                return JStacheFormatter.UnspecifiedFormatter.class;
            }

            @Override
            public Class<?> defaultProvider() {
                return DefaultFormatter.class;
            }

            @Override
            public @Nullable Class<?> providerFromJStache(JStache jstache) {
                return null;
            }

            @Override
            public Class<?> providerFromConfig(JStacheConfig config) {
                return Objects.requireNonNull(config.formatter());
            }

            @Override
            public String providesMethod(Class<?> type) {
                JStacheFormatter a = type.getAnnotation(JStacheFormatter.class);
                if (a == null) {
                    throw new IllegalArgumentException("Specified formatter provider is not annotated with @" + JStacheFormatter.class.getSimpleName());
                }
                return Objects.requireNonNull(a.providesMethod());
            }

            @Override
            public Function<@Nullable Object, String> provides(@Nullable Class<?> formatterType) throws Exception {
                if ((formatterType = this.nullToDefault(formatterType)).equals(DefaultFormatter.class)) {
                    return DefaultFormatter.provider();
                }
                if (formatterType.equals(SpecFormatter.class)) {
                    return SpecFormatter.provider();
                }
                return (Function)StaticProvider.super.provides(formatterType);
            }
        }

        record SimpleTemplateInfo(String templateName, String templatePath, Charset templateCharset, String templateMediaType, String templateString, Class<?> templateContentType, Function<String, String> templateEscaper, Function<@Nullable Object, String> templateFormatter, long lastLoaded, Class<?> modelClass) implements TemplateInfo
        {
            @Override
            public boolean supportsType(Class<?> type) {
                return this.modelClass().isAssignableFrom(type);
            }
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        static interface StaticProvider<P> {
            private @Nullable Class<?> autoToNull(@Nullable Class<?> type) {
                if (type == null || type.equals(this.autoProvider())) {
                    return null;
                }
                return type;
            }

            default public Class<?> nullToDefault(@Nullable Class<?> type) {
                Class<?> c = this.autoToNull(type);
                if (c == null) {
                    return this.defaultProvider();
                }
                return c;
            }

            public String providesMethod(Class<?> var1);

            public Class<?> autoProvider();

            public Class<?> defaultProvider();

            public @Nullable Class<?> providerFromJStache(JStache var1);

            public Class<?> providerFromConfig(JStacheConfig var1);

            default public Class<?> findProvider(Class<?> modelType, JStache jstache) {
                @Nullable Class provider = this.autoToNull(this.providerFromJStache(jstache));
                if (provider != null) {
                    return provider;
                }
                provider = Templates.findAnnotations(modelType, JStacheConfig.class).flatMap(config -> Optional.ofNullable(this.autoToNull(this.providerFromConfig((JStacheConfig)config))).stream()).findFirst().orElse(null);
                return this.nullToDefault(provider);
            }

            default public Map.Entry<Class<?>, P> providesFromModelType(Class<?> modelType, JStache jstache) throws Exception {
                Class<?> t = this.findProvider(modelType, jstache);
                return Map.entry(t, Objects.requireNonNull(this.provides(t)));
            }

            default public P provides(Class<?> type) throws Exception {
                String provides = this.providesMethod(type);
                Method method = type.getMethod(provides, new Class[0]);
                Object r = method.invoke((Object)provides, new Object[0]);
                return (P)r;
            }
        }
    }

    record DefaultPathInfo(Class<?> modelClass, String prefix, String suffix, boolean prefixUnspecified, boolean suffixUnspecified) implements PathInfo
    {
        static DefaultPathInfo of(Class<?> modelClass, @Nullable JStachePath path) {
            boolean prefixUnspecified;
            boolean suffixUnspecified;
            String suffix;
            String prefix;
            if (path == null) {
                prefix = "";
                suffix = "";
                suffixUnspecified = true;
                prefixUnspecified = true;
            } else {
                prefix = path.prefix();
                suffix = path.suffix();
                prefixUnspecified = "*".equals(prefix);
                suffixUnspecified = "*".equals(suffix);
                prefix = prefixUnspecified ? "" : prefix;
                suffix = suffixUnspecified ? "" : suffix;
            }
            return new DefaultPathInfo(modelClass, Objects.requireNonNull(prefix), Objects.requireNonNull(suffix), prefixUnspecified, suffixUnspecified);
        }

        @Override
        public String resolveFullPath(String path) {
            String resolvePath;
            String prefix = this.prefix();
            String suffix = this.suffix();
            if (path.isEmpty()) {
                resolvePath = DefaultPathInfo.resolveDefaultPath(this.modelClass);
                if (this.suffixUnspecified()) {
                    suffix = ".mustache";
                }
            } else {
                resolvePath = path;
            }
            return prefix + resolvePath + suffix;
        }

        private static String resolveDefaultPath(Class<?> model) {
            Object folder = model.getPackageName().replace('.', '/');
            folder = ((String)folder).isEmpty() ? folder : (String)folder + "/";
            String resolvedPath = (String)folder + model.getSimpleName();
            return resolvedPath;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface PathInfo {
        public String prefix();

        public String suffix();

        public String resolveFullPath(String var1);
    }
}

