/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.context;

import io.jstach.jstachio.Formatter;
import io.jstach.jstachio.context.ContextSupplier;
import io.jstach.jstachio.context.Internal;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.jdt.annotation.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ContextNode
extends Formatter.Formattable,
Iterable<ContextNode> {
    public static final String CONTEXT_BINDING_NAME = "@context";

    public static ContextNode of(Function<String, ?> function) {
        if (ContextNode.isNull(function)) {
            throw new NullPointerException("function is required");
        }
        return new Internal.FunctionContextNode(function);
    }

    private static boolean isNull(Object o) {
        return o == null;
    }

    public static ContextNode empty() {
        return Internal.EmptyContextNode.EMPTY;
    }

    public static ContextNode resolve(Object o) {
        if (o instanceof ContextSupplier) {
            ContextSupplier cs = (ContextSupplier)o;
            return cs.context();
        }
        if (o instanceof ContextNode) {
            ContextNode n = (ContextNode)o;
            return n;
        }
        return ContextNode.empty();
    }

    public static ContextNode resolve(Object first, Object second) {
        ContextNode f = ContextNode.resolve(first);
        if (f == ContextNode.empty()) {
            return ContextNode.resolve(second);
        }
        return f;
    }

    public static ContextNode ofRoot(@Nullable Object o) {
        if (o == null) {
            return ContextNode.empty();
        }
        return Internal.ContextNodeFactory.INSTANCE.create(null, o);
    }

    public @Nullable ContextNode get(String var1);

    public @Nullable ContextNode find(String var1);

    public Object object();

    default public String renderString() {
        return String.valueOf(this.object());
    }

    default public @Nullable ContextNode parent() {
        return null;
    }

    @Override
    public Iterator<@Nullable ContextNode> iterator();

    default public boolean isFalsey() {
        return !this.iterator().hasNext();
    }

    public static boolean isFalsey(@Nullable Object context) {
        if (context == null || Boolean.FALSE.equals(context)) {
            return true;
        }
        if (context instanceof Optional) {
            Optional o = (Optional)context;
            return o.isEmpty();
        }
        if (context instanceof Iterable) {
            Iterable it = (Iterable)context;
            return !it.iterator().hasNext();
        }
        if (context.getClass().isArray() && Array.getLength(context) == 0) {
            return true;
        }
        if (context instanceof ContextNode) {
            ContextNode n = (ContextNode)context;
            return ContextNode.isFalsey(n);
        }
        return false;
    }

    public static boolean isFalsey(@Nullable ContextNode context) {
        if (context == null) {
            return true;
        }
        return context.isFalsey();
    }
}

