/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.escapers;

import io.jstach.jstachio.Escaper;
import io.jstach.jstachio.Output;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

enum HtmlEscaper implements Escaper
{
    HTML5(HtmlEscaper.defaultMappings());

    private final String[] lookupTable;
    static final String QUOT = "&quot;";
    static final String AMP = "&amp;";
    static final String APOS = "&#x27;";
    static final String LT = "&lt;";
    static final String EQUAL = "&#x3D;";
    static final String GT = "&gt;";
    static final String BACK_TICK = "&#x60;";

    private HtmlEscaper(Map<Character, String> mapping) {
        String[] table = HtmlEscaper.createTable(mapping);
        this.lookupTable = table;
    }

    static Map<Character, String> defaultMappings() {
        return Map.of(Character.valueOf('\"'), QUOT, Character.valueOf('&'), AMP, Character.valueOf('\''), APOS, Character.valueOf('<'), LT, Character.valueOf('='), EQUAL, Character.valueOf('>'), GT, Character.valueOf('`'), BACK_TICK);
    }

    @Override
    public <A extends Output<E>, E extends Exception> void append(A a, CharSequence csq) throws E {
        int end = csq.length();
        for (int i = 0; i < end; ++i) {
            char c = csq.charAt(i);
            String found = HtmlEscaper.escapeChar(this.lookupTable, c);
            if (found == null) continue;
            a.append(csq, 0, i);
            a.append(found);
            int start = ++i;
            while (i < end) {
                c = csq.charAt(i);
                found = HtmlEscaper.escapeChar(this.lookupTable, c);
                if (found != null) {
                    a.append(csq, start, i);
                    a.append(found);
                    start = i + 1;
                }
                ++i;
            }
            a.append(csq, start, end);
            return;
        }
        a.append(csq);
    }

    @Override
    public <A extends Output<E>, E extends Exception> void append(A a, CharSequence csq, int start, int end) throws E {
        for (int i = 0; i < end; ++i) {
            char c = csq.charAt(i);
            String found = HtmlEscaper.escapeChar(this.lookupTable, c);
            if (found == null) continue;
            a.append(csq, 0, i);
            a.append(found);
            start = ++i;
            while (i < end) {
                c = csq.charAt(i);
                found = HtmlEscaper.escapeChar(this.lookupTable, c);
                if (found != null) {
                    a.append(csq, start, i);
                    a.append(found);
                    start = i + 1;
                }
                ++i;
            }
            a.append(csq, start, end);
            return;
        }
        a.append(csq, start, end);
    }

    @Override
    public <A extends Output<E>, E extends Exception> void append(A a, char c) throws E {
        String escaped = HtmlEscaper.escapeChar(this.lookupTable, c);
        if (escaped != null) {
            a.append(escaped);
        } else {
            a.append(c);
        }
    }

    @Override
    public <A extends Output<E>, E extends Exception> void append(A a, short s) throws E {
        a.append(s);
    }

    @Override
    public <A extends Output<E>, E extends Exception> void append(A a, int i) throws E {
        a.append(i);
    }

    @Override
    public <A extends Output<E>, E extends Exception> void append(A a, long l) throws E {
        a.append(l);
    }

    @Override
    public <A extends Output<E>, E extends Exception> void append(A a, double d) throws E {
        a.append(d);
    }

    @Override
    public <A extends Output<E>, E extends Exception> void append(A a, boolean b) throws E {
        a.append(b);
    }

    private static String[] createTable(Map<Character, String> mapping) {
        String[] table = new String[128];
        for (Map.Entry<Character, String> entry : mapping.entrySet()) {
            char k = entry.getKey().charValue();
            String value = entry.getValue();
            if (k > '\u007f') {
                throw new IllegalArgumentException("char '" + k + "' cannot be mapped as it is greater than 127");
            }
            table[k] = value;
        }
        return table;
    }

    private static @Nullable String escapeChar(String[] lookupTable, char c) {
        if (c > '\u007f') {
            return null;
        }
        return lookupTable[c];
    }
}

