/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.output;

import io.jstach.jstachio.output.BufferedEncodedOutput;
import io.jstach.jstachio.output.BufferedReadableByteChannel;
import io.jstach.jstachio.output.ChunkEncodedOutput;
import io.jstach.jstachio.output.OutputConsumer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

class ByteArrayChunkEncodedOutput
implements ChunkEncodedOutput<byte[]> {
    private final List<byte[]> chunks = new ArrayList<byte[]>();
    private final Charset charset;
    private int size = 0;
    private int bufferSizeHint = 0;

    public ByteArrayChunkEncodedOutput(Charset charset) {
        this.charset = charset;
    }

    @Override
    public void write(byte[] bytes) {
        this.addChunk(bytes);
    }

    private void addChunk(byte[] chunk) {
        this.chunks.add(chunk);
        int length = chunk.length;
        this.size += length;
        if (this.bufferSizeHint < length) {
            this.bufferSizeHint = length;
        }
    }

    @Override
    public byte[] toByteArray() {
        byte[] result = new byte[this.size];
        int index = 0;
        for (byte[] chunk : this.chunks) {
            System.arraycopy(chunk, 0, result, index, chunk.length);
            index += chunk.length;
        }
        return result;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int bufferSizeHint() {
        return this.bufferSizeHint;
    }

    @Override
    public Charset charset() {
        return this.charset;
    }

    @Override
    public <E extends Exception> void accept(OutputConsumer<E> consumer) throws E {
        for (byte[] chunk : this.chunks) {
            consumer.accept(chunk);
        }
    }

    @Override
    public ReadableByteChannel asReadableByteChannel() {
        return BufferedReadableByteChannel.of((BufferedEncodedOutput)this, this.chunks);
    }

    @Override
    public void close() {
    }

    @Override
    public Iterable<byte[]> getChunks() {
        return this.chunks;
    }
}

