/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.output;

import io.jstach.jstachio.output.BufferedEncodedOutput;
import io.jstach.jstachio.output.BufferedReadableByteChannel;
import java.nio.ByteBuffer;

class ByteBufferChannel
implements BufferedReadableByteChannel {
    private final ByteBuffer buffer;
    private final BufferedEncodedOutput output;
    private boolean closed = false;

    public ByteBufferChannel(ByteBuffer buffer, BufferedEncodedOutput output) {
        this.buffer = buffer;
        this.output = output;
    }

    @Override
    public int read(ByteBuffer dst) {
        int remaining = this.buffer.remaining();
        int bytesToRead = Math.min(remaining, dst.remaining());
        if (bytesToRead > 0) {
            int oldLimit = this.buffer.limit();
            this.buffer.limit(this.buffer.position() + bytesToRead);
            dst.put(this.buffer);
            this.buffer.limit(oldLimit);
            return bytesToRead;
        }
        return -1;
    }

    @Override
    public boolean isOpen() {
        return this.closed;
    }

    @Override
    public void close() {
        this.closed = true;
        this.output.close();
    }

    @Override
    public int size() {
        return this.output.size();
    }
}

