/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.spi;

import io.jstach.jstachio.spi.JStachioConfig;
import io.jstach.jstachio.spi.SystemPropertyConfig;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;

class CompositeConfig
implements JStachioConfig {
    private final List<JStachioConfig> configs;

    static JStachioConfig of(List<JStachioConfig> configs) {
        if (configs.isEmpty()) {
            return SystemPropertyConfig.INSTANCE;
        }
        if (configs.size() == 1) {
            return configs.get(0);
        }
        return new CompositeConfig(configs);
    }

    private CompositeConfig(List<JStachioConfig> configs) {
        this.configs = configs;
    }

    @Override
    public @Nullable String getProperty(String key) {
        for (JStachioConfig c : this.configs) {
            String v = c.getProperty(key);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    @Override
    public System.Logger getLogger(String name) {
        return this.configs.get(0).getLogger(name);
    }
}

