/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.spi;

import io.jstach.jstachio.spi.DefaultJStachioExtensions;
import io.jstach.jstachio.spi.JStachioConfig;
import io.jstach.jstachio.spi.JStachioExtension;
import io.jstach.jstachio.spi.JStachioFilter;
import io.jstach.jstachio.spi.JStachioTemplateFinder;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface JStachioExtensions {
    public static JStachioExtensions of(Iterable<? extends JStachioExtension> extensions) {
        return JStachioExtensions.of(StreamSupport.stream(extensions.spliterator(), false));
    }

    public static JStachioExtensions of(Stream<? extends JStachioExtension> extensions) {
        return DefaultJStachioExtensions.of(extensions);
    }

    public static JStachioExtensions of() {
        ServiceLoader<JStachioExtension> it = ServiceLoader.load(JStachioExtension.class);
        return JStachioExtensions.of(it);
    }

    public JStachioConfig getConfig();

    public JStachioFilter getFilter();

    public JStachioTemplateFinder getTemplateFinder();

    public List<JStachioExtension> getExtensions();

    default public <T extends JStachioExtension> Optional<T> findExtension(Class<T> c) {
        return this.getExtensions().stream().filter(s -> c.isAssignableFrom(s.getClass())).map(c::cast).findFirst();
    }

    public static interface Provider {
        public JStachioExtensions extensions();
    }
}

