/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.spi;

import io.jstach.jstachio.spi.Templates;
import java.util.Collection;
import java.util.NoSuchElementException;

class TemplateNotFoundException
extends NoSuchElementException {
    private static final long serialVersionUID = -4016359589653582060L;
    private final Class<?> modelType;

    public TemplateNotFoundException(Class<?> modelType) {
        super(TemplateNotFoundException.errorMessage(modelType));
        this.modelType = modelType;
    }

    public TemplateNotFoundException(Class<?> modelType, Collection<Templates.TemplateLoadStrategy> strategies) {
        super(TemplateNotFoundException.errorMessage(modelType, strategies));
        this.modelType = modelType;
    }

    public TemplateNotFoundException(String message, Class<?> modelType) {
        super(message + " " + TemplateNotFoundException.errorMessage(modelType));
        this.modelType = modelType;
    }

    protected static String errorMessage(Class<?> modelType) {
        return "Template not found for type: '" + modelType + "'";
    }

    protected static String errorMessage(Class<?> modelType, Collection<Templates.TemplateLoadStrategy> strategies) {
        return TemplateNotFoundException.errorMessage(modelType) + ", using strategies: " + strategies;
    }

    public Class<?> modelType() {
        return this.modelType;
    }
}

