/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.rainbowgum.jdk.jul;

import io.jstach.rainbowgum.LogConfig;
import io.jstach.rainbowgum.LogProperties;
import io.jstach.rainbowgum.LogProperty;
import io.jstach.rainbowgum.jdk.jul.SystemLoggerQueueJULHandler;
import io.jstach.rainbowgum.spi.RainbowGumServiceProvider;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class JULConfigurator
implements RainbowGumServiceProvider.Configurator,
AutoCloseable {
    public static final String JUL_DISABLE_PROPERTY = "logging.jul.disable";
    public static final String JUL_LEVEL_DISABLE_PROPERTY = "logging.jul.level.disable";
    static final LogProperty.Property<Boolean> JUL_DISABLE_PROPERTY_ = LogProperty.Property.builder().ofBoolean().build("logging.jul.disable");
    static final LogProperty.Property<Boolean> JUL_LEVEL_DISABLE_PROPERTY_ = LogProperty.Property.builder().ofBoolean().build("logging.jul.level.disable");
    private volatile boolean installed = false;

    public boolean configure(LogConfig config, RainbowGumServiceProvider.Pass pass) {
        Logger logger;
        if (!JULConfigurator.install(config.properties())) {
            return true;
        }
        this.installed = true;
        Boolean disableLevel = (Boolean)JUL_LEVEL_DISABLE_PROPERTY_.get(config.properties()).value((Object)false);
        if (!disableLevel.booleanValue() && (logger = Logger.getLogger("")) != null) {
            System.Logger.Level systemLevel = JULConfigurator.traceToAll(config.levelResolver().resolveLevel(""));
            logger.setLevel(this.julLevel(systemLevel));
        }
        return true;
    }

    private static System.Logger.Level traceToAll(System.Logger.Level level) {
        if (level == System.Logger.Level.TRACE) {
            return System.Logger.Level.ALL;
        }
        return level;
    }

    public static boolean install(LogProperties properties) {
        if (((Boolean)JUL_DISABLE_PROPERTY_.get(properties).value((Object)false)).booleanValue()) {
            return false;
        }
        if (!JULConfigurator.isLoggingModuleAvailable()) {
            return false;
        }
        if (!SystemLoggerQueueJULHandler.isInstalled()) {
            SystemLoggerQueueJULHandler.install();
        }
        return true;
    }

    private static boolean isLoggingModuleAvailable() {
        ModuleLayer bootLayer = ModuleLayer.boot();
        return bootLayer.findModule("java.logging").isPresent();
    }

    public static boolean isInstalled() {
        return SystemLoggerQueueJULHandler.isInstalled();
    }

    @Override
    public void close() {
        Logger logger;
        if (this.installed && (logger = Logger.getLogger("")) != null) {
            logger.setLevel(Level.INFO);
        }
    }

    private Level julLevel(System.Logger.Level level) {
        Level julLevel = switch (level) {
            default -> throw new MatchException(null, null);
            case System.Logger.Level.TRACE -> Level.FINEST;
            case System.Logger.Level.DEBUG -> Level.FINE;
            case System.Logger.Level.INFO -> Level.INFO;
            case System.Logger.Level.WARNING -> Level.WARNING;
            case System.Logger.Level.ERROR -> Level.SEVERE;
            case System.Logger.Level.ALL -> Level.ALL;
            case System.Logger.Level.OFF -> Level.OFF;
        };
        return julLevel;
    }
}

