/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.rainbowgum.jdk.jul;

import io.jstach.rainbowgum.KeyValues;
import io.jstach.rainbowgum.LogEvent;
import io.jstach.rainbowgum.LogMessageFormatter;
import io.jstach.rainbowgum.LogRouter;
import java.time.Instant;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.Nullable;

final class SystemLoggerQueueJULHandler
extends Handler {
    private static final int TRACE_LEVEL_THRESHOLD = Level.FINEST.intValue();
    private static final int DEBUG_LEVEL_THRESHOLD = Level.FINE.intValue();
    private static final int INFO_LEVEL_THRESHOLD = Level.INFO.intValue();
    private static final int WARN_LEVEL_THRESHOLD = Level.WARNING.intValue();

    @Override
    public void publish(@Nullable LogRecord rec) {
        if (rec == null) {
            return;
        }
        int lv = rec.getLevel().intValue();
        System.Logger.Level level = Integer.MIN_VALUE == lv ? System.Logger.Level.TRACE : (TRACE_LEVEL_THRESHOLD >= lv ? System.Logger.Level.TRACE : (DEBUG_LEVEL_THRESHOLD >= lv ? System.Logger.Level.DEBUG : (INFO_LEVEL_THRESHOLD >= lv ? System.Logger.Level.INFO : (WARN_LEVEL_THRESHOLD >= lv ? System.Logger.Level.WARNING : (Integer.MAX_VALUE == lv ? System.Logger.Level.OFF : System.Logger.Level.ERROR)))));
        String loggerName = rec.getLoggerName();
        if (loggerName == null) {
            return;
        }
        @Nullable Throwable cause = rec.getThrown();
        LogRouter.RootRouter router = LogRouter.global();
        LogRouter.Route route = router.route(loggerName, level);
        if (route.isEnabled()) {
            Object[] args;
            @Nullable String msg = SystemLoggerQueueJULHandler.alreadyFormattedOrNull(rec);
            if (msg != null) {
                args = null;
            } else {
                msg = Objects.requireNonNullElse(rec.getMessage(), "");
                args = rec.getParameters();
            }
            Instant timestamp = rec.getInstant();
            long threadId = rec.getLongThreadID();
            String threadName = "";
            long currentThreadId = Thread.currentThread().threadId();
            if (currentThreadId == threadId) {
                threadName = Thread.currentThread().getName();
            }
            LogEvent event = LogEvent.ofAll((Instant)timestamp, (String)threadName, (long)threadId, (System.Logger.Level)level, (String)loggerName, (String)msg, (KeyValues)KeyValues.of(), (Throwable)cause, (LogMessageFormatter)LogMessageFormatter.StandardMessageFormatter.JUL, (Object[])args);
            route.log(event);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    private static @Nullable String alreadyFormattedOrNull(LogRecord record) {
        String message = record.getMessage();
        if (message == null) {
            return null;
        }
        ResourceBundle bundle = record.getResourceBundle();
        if (bundle != null) {
            try {
                return bundle.getString(message);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isInstalled() {
        Handler[] handlers;
        Logger rootLogger = SystemLoggerQueueJULHandler.getRootLogger();
        for (Handler handler : handlers = rootLogger.getHandlers()) {
            if (!(handler instanceof SystemLoggerQueueJULHandler)) continue;
            return true;
        }
        return false;
    }

    public static void removeHandlersForRootLogger() {
        Handler[] handlers;
        Logger rootLogger = SystemLoggerQueueJULHandler.getRootLogger();
        for (Handler handler : handlers = rootLogger.getHandlers()) {
            rootLogger.removeHandler(handler);
        }
    }

    private static Logger getRootLogger() {
        Logger logger = LogManager.getLogManager().getLogger("");
        if (logger == null) {
            throw new IllegalStateException("log manager return null for root logger");
        }
        return logger;
    }

    public static void install() {
        SystemLoggerQueueJULHandler.removeHandlersForRootLogger();
        SystemLoggerQueueJULHandler.getRootLogger().addHandler(new SystemLoggerQueueJULHandler());
    }
}

