/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.rainbowgum.systemlogger;

import io.jstach.rainbowgum.KeyValues;
import io.jstach.rainbowgum.LogEvent;
import io.jstach.rainbowgum.LogEventLogger;
import io.jstach.rainbowgum.LogMessageFormatter;
import java.time.Instant;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.Nullable;

record LevelSystemLogger(String loggerName, int level, LogEventLogger logger) implements System.Logger
{
    static System.Logger of(String loggerName, System.Logger.Level level, LogEventLogger logger) {
        if (level == System.Logger.Level.OFF) {
            return new OffSystemLogger(loggerName);
        }
        return new LevelSystemLogger(loggerName, LevelSystemLogger.fixLevel(level).getSeverity(), logger);
    }

    static System.Logger.Level fixLevel(System.Logger.Level level) {
        if (level == System.Logger.Level.ALL) {
            return System.Logger.Level.TRACE;
        }
        return level;
    }

    @Override
    public String getName() {
        return this.loggerName;
    }

    @Override
    public final boolean isLoggable(System.Logger.Level level) {
        if (level == System.Logger.Level.OFF) {
            return false;
        }
        return LevelSystemLogger.fixLevel(level).getSeverity() >= this.level;
    }

    @Override
    public void log(System.Logger.Level level, @Nullable String msg) {
        if (this.isLoggable(level)) {
            String formattedMessage = msg == null ? "" : msg;
            LogEvent event = LogEvent.of((System.Logger.Level)level, (String)this.loggerName, (String)formattedMessage, null);
            this.logger.log(event);
        }
    }

    @Override
    public void log(System.Logger.Level level, Supplier<String> msgSupplier) {
        if (this.isLoggable(level)) {
            String formattedMessage = Objects.requireNonNullElse(msgSupplier.get(), "");
            LogEvent event = LogEvent.of((System.Logger.Level)level, (String)this.loggerName, (String)formattedMessage, null);
            this.logger.log(event);
        }
    }

    @Override
    public void log(System.Logger.Level level, @Nullable Object obj) {
        if (this.isLoggable(level)) {
            String formattedMessage = obj == null ? "" : obj.toString();
            LogEvent event = LogEvent.of((System.Logger.Level)level, (String)this.loggerName, (String)formattedMessage, null);
            this.logger.log(event);
        }
    }

    @Override
    public void log(System.Logger.Level level, @Nullable String msg, @Nullable Throwable thrown) {
        if (this.isLoggable(level)) {
            String formattedMessage = Objects.requireNonNullElse(msg, "");
            LogEvent event = LogEvent.of((System.Logger.Level)level, (String)this.loggerName, (String)formattedMessage, (Throwable)thrown);
            this.logger.log(event);
        }
    }

    @Override
    public void log(System.Logger.Level level, Supplier<String> msgSupplier, Throwable thrown) {
        if (this.isLoggable(level)) {
            String formattedMessage = Objects.requireNonNullElse(msgSupplier.get(), "");
            LogEvent event = LogEvent.of((System.Logger.Level)level, (String)this.loggerName, (String)formattedMessage, (Throwable)thrown);
            this.logger.log(event);
        }
    }

    @Override
    public void log(System.Logger.Level level, @Nullable String format, Object ... params) {
        if (this.isLoggable(level)) {
            Thread currentThread = Thread.currentThread();
            Instant timestamp = Instant.now();
            String threadName = currentThread.getName();
            long threadId = currentThread.threadId();
            String message = Objects.requireNonNullElse(format, "");
            Throwable throwable = null;
            LogEvent event = LogEvent.ofAll((Instant)timestamp, (String)threadName, (long)threadId, (System.Logger.Level)level, (String)this.loggerName, (String)message, (KeyValues)KeyValues.of(), throwable, (LogMessageFormatter)LogMessageFormatter.StandardMessageFormatter.JUL, (Object[])params);
            this.logger.log(event);
        }
    }

    @Override
    public void log(System.Logger.Level level, @Nullable ResourceBundle bundle, @Nullable String msg, @Nullable Throwable thrown) {
        if (this.isLoggable(level)) {
            String formattedMessage = Objects.requireNonNullElse(msg, "");
            LogEvent event = LogEvent.of((System.Logger.Level)level, (String)this.loggerName, (String)formattedMessage, (Throwable)thrown);
            this.logger.log(event);
        }
    }

    @Override
    public void log(System.Logger.Level level, @Nullable ResourceBundle bundle, @Nullable String format, Object ... params) {
        if (this.isLoggable(level)) {
            Thread currentThread = Thread.currentThread();
            Instant timestamp = Instant.now();
            String threadName = currentThread.getName();
            long threadId = currentThread.threadId();
            String message = Objects.requireNonNullElse(format, "");
            Throwable throwable = null;
            LogEvent event = LogEvent.ofAll((Instant)timestamp, (String)threadName, (long)threadId, (System.Logger.Level)level, (String)this.loggerName, (String)message, (KeyValues)KeyValues.of(), throwable, (LogMessageFormatter)LogMessageFormatter.StandardMessageFormatter.JUL, (Object[])params);
            this.logger.log(event);
        }
    }

    record OffSystemLogger(String loggerName) implements System.Logger
    {
        @Override
        public String getName() {
            return this.loggerName;
        }

        @Override
        public boolean isLoggable(System.Logger.Level level) {
            return false;
        }

        @Override
        public void log(System.Logger.Level level, ResourceBundle bundle, String msg, Throwable thrown) {
        }

        @Override
        public void log(System.Logger.Level level, ResourceBundle bundle, String format, Object ... params) {
        }
    }
}

