/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.rainbowgum.systemlogger;

import io.jstach.rainbowgum.KeyValues;
import io.jstach.rainbowgum.LogEvent;
import io.jstach.rainbowgum.LogMessageFormatter;
import io.jstach.rainbowgum.LogRouter;
import java.time.Instant;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.Nullable;

public final class RainbowGumSystemLogger
implements System.Logger {
    private final String loggerName;
    private final LogRouter router;

    public static RainbowGumSystemLogger of(String loggerName, LogRouter router) {
        return new RainbowGumSystemLogger(loggerName, router);
    }

    RainbowGumSystemLogger(String loggerName, LogRouter router) {
        this.loggerName = loggerName;
        this.router = router;
    }

    private static System.Logger.Level fixLevel(System.Logger.Level level) {
        if (level == System.Logger.Level.ALL) {
            return System.Logger.Level.TRACE;
        }
        return level;
    }

    @Override
    public String getName() {
        return this.loggerName;
    }

    @Override
    public boolean isLoggable(System.Logger.Level level) {
        return this.router.route(this.loggerName, RainbowGumSystemLogger.fixLevel(level)).isEnabled();
    }

    @Override
    public void log(System.Logger.Level level, @Nullable String msg) {
        this.log(level, msg, (Throwable)null);
    }

    @Override
    public void log(System.Logger.Level level, Supplier<@Nullable String> msgSupplier) {
        this.log(level, msgSupplier, (Throwable)null);
    }

    @Override
    public void log(System.Logger.Level level, Object obj) {
        LogRouter.Route route = this.router.route(this.loggerName, level = RainbowGumSystemLogger.fixLevel(level));
        if (route.isEnabled()) {
            String formattedMessage = obj == null ? "" : obj.toString();
            LogEvent event = LogEvent.of((System.Logger.Level)level, (String)this.loggerName, (String)formattedMessage, null);
            route.log(event);
        }
    }

    @Override
    public void log(System.Logger.Level level, @Nullable String msg, @Nullable Throwable throwable) {
        LogRouter.Route route = this.router.route(this.loggerName, level = RainbowGumSystemLogger.fixLevel(level));
        if (route.isEnabled()) {
            String formattedMessage = Objects.requireNonNullElse(msg, "");
            LogEvent event = LogEvent.of((System.Logger.Level)level, (String)this.loggerName, (String)formattedMessage, (Throwable)throwable);
            route.log(event);
        }
    }

    @Override
    public void log(System.Logger.Level level, Supplier<@Nullable String> msgSupplier, @Nullable Throwable throwable) {
        LogRouter.Route route = this.router.route(this.loggerName, level = RainbowGumSystemLogger.fixLevel(level));
        if (route.isEnabled()) {
            String formattedMessage = Objects.requireNonNullElse(msgSupplier.get(), "");
            LogEvent event = LogEvent.of((System.Logger.Level)level, (String)this.loggerName, (String)formattedMessage, (Throwable)throwable);
            route.log(event);
        }
    }

    @Override
    public void log(System.Logger.Level level, @Nullable ResourceBundle bundle, @Nullable String msg, @Nullable Throwable throwable) {
        this.log(level, msg, throwable);
    }

    @Override
    public void log(System.Logger.Level level, @Nullable ResourceBundle bundle, @Nullable String format, Object ... args) {
        LogRouter.Route route = this.router.route(this.loggerName, level = RainbowGumSystemLogger.fixLevel(level));
        if (route.isEnabled()) {
            Instant timestamp = Instant.now();
            String threadName = Thread.currentThread().getName();
            long threadId = Thread.currentThread().threadId();
            String message = Objects.requireNonNullElse(format, "");
            Throwable throwable = null;
            LogEvent event = LogEvent.ofAll((Instant)timestamp, (String)threadName, (long)threadId, (System.Logger.Level)level, (String)this.loggerName, (String)message, (KeyValues)KeyValues.of(), throwable, (LogMessageFormatter)LogMessageFormatter.StandardMessageFormatter.JUL, (Object[])args);
            route.log(event);
        }
    }
}

