/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.rainbowgum.systemlogger;

import io.jstach.rainbowgum.LogEventLogger;
import io.jstach.rainbowgum.LogProperties;
import io.jstach.rainbowgum.LogProperty;
import io.jstach.rainbowgum.LogRouter;
import io.jstach.rainbowgum.MetaLog;
import io.jstach.rainbowgum.RainbowGum;
import io.jstach.rainbowgum.spi.RainbowGumServiceProvider;
import io.jstach.rainbowgum.systemlogger.LevelSystemLogger;
import io.jstach.rainbowgum.systemlogger.RainbowGumSystemLogger;
import java.util.Locale;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.Nullable;

public abstract class RainbowGumSystemLoggerFinder
extends System.LoggerFinder {
    public static final String INITIALIZE_RAINBOW_GUM_PROPERTY = "logging.systemlogger.initialize";
    private final RouterProvider routerProvider;

    protected RainbowGumSystemLoggerFinder(Supplier<? extends InitOption> optSupplier) {
        try {
            InitOption opt = optSupplier.get();
            this.routerProvider = switch (opt.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> n -> LogRouter.global();
                case 1 -> new InitRouterProvider(this, RainbowGum::of);
                case 2 -> {
                    if (RainbowGumServiceProvider.RainbowGumEagerLoad.exists()) {
                        yield n -> LogRouter.global();
                    }
                    yield new InitRouterProvider(this, RainbowGum::of);
                }
                case 3 -> new InitRouterProvider(this, () -> {
                    RainbowGum gum = RainbowGum.getOrNull();
                    if (gum == null) {
                        throw new IllegalStateException("SystemLogging was configured to reuse a loaded Rainbow Gum but none was found. logging.systemlogger.initialize=" + String.valueOf((Object)opt));
                    }
                    return gum;
                });
            };
        }
        catch (Exception e) {
            MetaLog.error(this.getClass(), (String)"Failed to create System.LoggerFinder", (Throwable)e);
            throw e;
        }
    }

    @Override
    public System.Logger getLogger(String name, Module module) {
        LogRouter.RootRouter router = this.routerProvider.router(name);
        if (!router.isChangeable(name)) {
            System.Logger.Level level = router.levelResolver().resolveLevel(name);
            return LevelSystemLogger.of(name, level, (LogEventLogger)router.route(name, level));
        }
        return RainbowGumSystemLogger.of(name, (LogRouter)router);
    }

    protected static InitOption initOption(LogProperties properties) {
        return (InitOption)((Object)LogProperty.Property.builder().map(InitOption::parse).build(INITIALIZE_RAINBOW_GUM_PROPERTY).get(properties).value((Object)InitOption.CHECK));
    }

    public static enum InitOption {
        FALSE,
        TRUE,
        CHECK,
        REUSE;


        public static InitOption parse(String input) {
            if (input.isBlank()) {
                return FALSE;
            }
            return InitOption.valueOf(input.toUpperCase(Locale.ROOT));
        }
    }

    private static interface RouterProvider {
        public LogRouter.RootRouter router(String var1);
    }

    private class InitRouterProvider
    implements RouterProvider {
        private final Supplier<RainbowGum> supplier;
        private volatile @Nullable RainbowGum gum = null;

        public InitRouterProvider(RainbowGumSystemLoggerFinder rainbowGumSystemLoggerFinder, Supplier<RainbowGum> supplier) {
            this.supplier = supplier;
        }

        @Override
        public LogRouter.RootRouter router(String loggerName) {
            RainbowGum gum = this.gum;
            if (gum == null) {
                gum = this.gum = this.supplier.get();
            }
            LogRouter.RootRouter router = gum.config().changePublisher().isEnabled(loggerName) ? LogRouter.global() : gum.router();
            return router;
        }
    }
}

