/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.log;

import io.jstuff.log.Level;
import io.jstuff.log.LoggerFactory;
import java.time.Clock;
import java.util.function.Supplier;

public interface Logger {
    public String getName();

    default public Level getLevel() {
        return Level.INFO;
    }

    default public void setLevel(Level level) {
    }

    default public Clock getClock() {
        return LoggerFactory.systemClock;
    }

    default public void setClock(Clock clock) {
    }

    public void trace(Object var1);

    public void debug(Object var1);

    public void info(Object var1);

    public void warn(Object var1);

    public void error(Object var1);

    public void error(Throwable var1, Object var2);

    default public boolean isTraceEnabled() {
        return this.getLevel().ordinal() <= Level.TRACE.ordinal();
    }

    default public boolean isDebugEnabled() {
        return this.getLevel().ordinal() <= Level.DEBUG.ordinal();
    }

    default public boolean isInfoEnabled() {
        return this.getLevel().ordinal() <= Level.INFO.ordinal();
    }

    default public boolean isWarnEnabled() {
        return this.getLevel().ordinal() <= Level.WARN.ordinal();
    }

    default public boolean isErrorEnabled() {
        return this.getLevel().ordinal() <= Level.ERROR.ordinal();
    }

    default public boolean isEnabled(Level level) {
        return this.getLevel().ordinal() <= level.ordinal();
    }

    default public void trace(Supplier<Object> messageSupplier) {
        if (this.isTraceEnabled()) {
            this.trace(messageSupplier.get());
        }
    }

    default public void debug(Supplier<Object> messageSupplier) {
        if (this.isDebugEnabled()) {
            this.debug(messageSupplier.get());
        }
    }

    default public void info(Supplier<Object> messageSupplier) {
        if (this.isInfoEnabled()) {
            this.info(messageSupplier.get());
        }
    }

    default public void warn(Supplier<Object> messageSupplier) {
        if (this.isWarnEnabled()) {
            this.warn(messageSupplier.get());
        }
    }

    default public void error(Supplier<Object> messageSupplier) {
        if (this.isErrorEnabled()) {
            this.error(messageSupplier.get());
        }
    }

    default public void error(Throwable throwable, Supplier<Object> messageSupplier) {
        if (this.isErrorEnabled()) {
            this.error(throwable, messageSupplier.get());
        }
    }

    default public void log(Level level, Object message) {
        switch (level) {
            case TRACE: {
                this.trace(message);
                break;
            }
            case DEBUG: {
                this.debug(message);
                break;
            }
            case INFO: {
                this.info(message);
                break;
            }
            case WARN: {
                this.warn(message);
                break;
            }
            case ERROR: {
                this.error(message);
            }
        }
    }

    default public void log(Level level, Supplier<Object> messageSupplier) {
        switch (level) {
            case TRACE: {
                this.trace(messageSupplier);
                break;
            }
            case DEBUG: {
                this.debug(messageSupplier);
                break;
            }
            case INFO: {
                this.info(messageSupplier);
                break;
            }
            case WARN: {
                this.warn(messageSupplier);
                break;
            }
            case ERROR: {
                this.error(messageSupplier);
            }
        }
    }
}

