/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.log;

import io.jstuff.log.Level;
import io.jstuff.log.Logger;
import io.jstuff.util.IntOutput;
import java.io.IOException;
import java.time.Clock;
import java.util.Objects;
import java.util.function.Consumer;

public abstract class AbstractLogger
implements Logger {
    public static final int TAB_WIDTH = 4;
    private final String name;
    private Level level;
    private final Clock clock;

    protected AbstractLogger(String name, Level level, Clock clock) {
        this.name = name;
        this.level = level;
        this.clock = clock;
    }

    public String getName() {
        return this.name;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = Objects.requireNonNull(level);
    }

    public Clock getClock() {
        return this.clock;
    }

    public static void outputMultiLine(String message, Consumer<String> outputFunction) {
        int n = message.length();
        if (n == 0 || AbstractLogger.isAllASCII(message) && message.charAt(message.length() - 1) != ' ') {
            outputFunction.accept(message);
            return;
        }
        int j = 0;
        StringBuilder sb = new StringBuilder(80);
        while (true) {
            char ch;
            if (j == n) {
                outputFunction.accept(AbstractLogger.trimmedString(sb));
                return;
            }
            if ((ch = message.charAt(j++)) == '\n') {
                outputFunction.accept(AbstractLogger.trimmedString(sb));
                sb.setLength(0);
                if (j < n && message.charAt(j) == '\r') {
                    ++j;
                }
                if (j >= n) {
                    return;
                }
            } else if (ch == '\r') {
                outputFunction.accept(AbstractLogger.trimmedString(sb));
                sb.setLength(0);
                if (j < n && message.charAt(j) == '\n') {
                    ++j;
                }
                if (j >= n) {
                    return;
                }
            } else {
                if (ch >= ' ' && ch < '\u007f') {
                    sb.append(ch);
                    continue;
                }
                if (ch == '\t') {
                    do {
                        sb.append(' ');
                    } while (sb.length() % 4 != 0);
                    continue;
                }
                if (ch == '\u0000') continue;
                sb.append('\\');
                sb.append('u');
                try {
                    IntOutput.append4HexLC((Appendable)sb, (int)ch);
                }
                catch (IOException iOException) {}
                continue;
            }
            sb.setLength(0);
        }
    }

    public static boolean isAllASCII(String s) {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char ch = s.charAt(i);
            if (ch >= ' ' && ch < '\u007f') continue;
            return false;
        }
        return true;
    }

    public static String trimmedString(StringBuilder sb) {
        int i = sb.length();
        if (i == 0) {
            return "";
        }
        if (sb.charAt(--i) == ' ') {
            while (true) {
                if (i == 0) {
                    return "";
                }
                if (sb.charAt(i - 1) != ' ') break;
                --i;
            }
            sb.setLength(i);
        }
        return sb.toString();
    }
}

