/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.log;

import io.jstuff.log.Level;
import io.jstuff.log.Logger;
import io.jstuff.log.LoggerFactory;
import java.time.Clock;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractLoggerFactory<L extends Logger>
implements LoggerFactory<L> {
    public static final Level systemDefaultLevel;
    private Level defaultLevel;
    private Clock defaultClock;
    private final Map<String, L> loggerCache = new HashMap<String, L>();

    protected AbstractLoggerFactory(Level defaultLevel, Clock defaultClock) {
        this.defaultLevel = defaultLevel;
        this.defaultClock = defaultClock;
    }

    public Level getDefaultLevel() {
        return this.defaultLevel;
    }

    public void setDefaultLevel(Level defaultLevel) {
        this.defaultLevel = defaultLevel;
    }

    public Clock getDefaultClock() {
        return this.defaultClock;
    }

    public void setDefaultClock(Clock defaultClock) {
        this.defaultClock = defaultClock;
    }

    protected synchronized L getCachedLogger(String name) {
        return (L)((Logger)this.loggerCache.get(name));
    }

    protected synchronized void putCachedLogger(String name, L logger) {
        this.loggerCache.put(name, logger);
    }

    public L getLogger(String name, Level level, Clock clock) {
        LoggerFactory.validateLoggerName((String)name);
        L logger = this.getCachedLogger(name);
        if (logger != null && logger.getLevel().equals((Object)level) && logger.getClock().equals(clock)) {
            return logger;
        }
        logger = this.createLogger(name, level, clock);
        this.putCachedLogger(name, logger);
        return logger;
    }

    protected abstract L createLogger(String var1, Level var2, Clock var3);

    static {
        Level level = Level.INFO;
        String env = System.getProperty("io.jstuff.log.defaultLevel");
        if (env != null) {
            try {
                level = Level.valueOf((String)env.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        systemDefaultLevel = level;
    }
}

