/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.log;

import io.jstuff.log.AbstractFormatter;
import io.jstuff.log.AbstractLogger;
import io.jstuff.log.Level;
import io.jstuff.log.LogListener;
import io.jstuff.log.LoggerException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Clock;
import java.util.Objects;

public class ConsoleLogger
extends AbstractLogger {
    public static final PrintStream defaultOutput = System.out;
    private final PrintStream output;
    private char separator;

    ConsoleLogger(String name, Level level, Clock clock, PrintStream output) {
        super(name, level, clock);
        this.output = Objects.requireNonNull(output);
        this.setLevel(level);
        this.separator = (char)124;
    }

    public PrintStream getOutput() {
        return this.output;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public void trace(Object message) {
        if (this.isTraceEnabled()) {
            this.outputLog(Level.TRACE, message, null);
        }
    }

    public void debug(Object message) {
        if (this.isDebugEnabled()) {
            this.outputLog(Level.DEBUG, message, null);
        }
    }

    public void info(Object message) {
        if (this.isInfoEnabled()) {
            this.outputLog(Level.INFO, message, null);
        }
    }

    public void warn(Object message) {
        if (this.isWarnEnabled()) {
            this.outputLog(Level.WARN, message, null);
        }
    }

    public void error(Object message) {
        if (this.isErrorEnabled()) {
            this.outputLog(Level.ERROR, message, null);
        }
    }

    public void error(Throwable throwable, Object message) {
        if (this.isErrorEnabled()) {
            int dayMillis = this.outputLog(Level.ERROR, message, throwable);
            StringWriter sw = new StringWriter();
            throwable.printStackTrace(new PrintWriter(sw));
            this.outputMulti(dayMillis, Level.ERROR, sw.toString());
        }
    }

    public void log(Level level, Object message) {
        if (this.isEnabled(level)) {
            this.outputLog(level, message, null);
        }
    }

    private int outputLog(Level level, Object message, Throwable throwable) {
        long time = this.getClock().millis();
        if (LogListener.present()) {
            LogListener.invokeAll(time, this, level, message, throwable);
        }
        int dayMillis = AbstractFormatter.getDayMillis(time, this.getClock().getZone());
        this.outputMulti(dayMillis, level, String.valueOf(message));
        return dayMillis;
    }

    private void outputMulti(int dayMillis, Level level, String text) {
        ConsoleLogger.outputMultiLine(text, line -> {
            StringBuilder sb = new StringBuilder(120);
            AbstractFormatter.outputTime(dayMillis, ch -> sb.append((char)ch));
            sb.append(this.separator).append(this.getName());
            sb.append(this.separator).append(level);
            sb.append(this.separator).append(' ').append((String)line);
            this.output.println(sb);
            if (this.output.checkError()) {
                throw new LoggerException("Error writing ConsoleLogger");
            }
        });
    }
}

