/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.log;

import io.jstuff.log.Level;
import io.jstuff.log.Logger;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public abstract class LogListener
implements AutoCloseable {
    private static final List<LogListener> listeners = new ArrayList<LogListener>();
    private static final LogListener[] emptyArray = new LogListener[0];

    public LogListener() {
        LogListener.add(this);
    }

    @Override
    public void close() {
        LogListener.remove(this);
    }

    public abstract void receive(Instant var1, Logger var2, Level var3, Object var4, Throwable var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(LogListener listener) {
        List<LogListener> list = listeners;
        synchronized (list) {
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(LogListener listener) {
        List<LogListener> list = listeners;
        synchronized (list) {
            listeners.remove(listener);
        }
    }

    public static boolean present() {
        return !listeners.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeAll(Instant time, Logger logger, Level level, Object message, Throwable throwable) {
        LogListener single = null;
        LogListener[] array = emptyArray;
        LogListener[] logListenerArray = listeners;
        synchronized (listeners) {
            int n = listeners.size();
            if (n > 0) {
                if (n == 1) {
                    single = listeners.get(0);
                } else {
                    array = new LogListener[n];
                    array = listeners.toArray(array);
                }
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            if (single != null) {
                single.receive(time, logger, level, message, throwable);
            } else {
                for (LogListener listener : array) {
                    listener.receive(time, logger, level, message, throwable);
                }
            }
            return;
        }
    }
}

