/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.log;

import io.jstuff.log.AbstractLogger;
import io.jstuff.log.Level;
import io.jstuff.log.LogListener;
import io.jstuff.log.LoggerProxy;
import java.lang.reflect.InvocationTargetException;
import java.time.Clock;
import java.time.Instant;
import java.util.function.Supplier;

public class ProxyLogger
extends AbstractLogger {
    private final LoggerProxy loggerProxy;
    private final Object implementationLogger;

    ProxyLogger(String name, Level level, Clock clock, LoggerProxy loggerProxy) throws InvocationTargetException, IllegalAccessException {
        super(name, level, clock);
        this.loggerProxy = loggerProxy;
        this.implementationLogger = loggerProxy.getLogger(name);
    }

    public boolean isTraceEnabled() {
        return super.isTraceEnabled() && this.loggerProxy.isTraceEnabled(this.implementationLogger);
    }

    public boolean isDebugEnabled() {
        return super.isDebugEnabled() && this.loggerProxy.isDebugEnabled(this.implementationLogger);
    }

    public boolean isInfoEnabled() {
        return super.isInfoEnabled() && this.loggerProxy.isInfoEnabled(this.implementationLogger);
    }

    public boolean isWarnEnabled() {
        return super.isWarnEnabled() && this.loggerProxy.isWarnEnabled(this.implementationLogger);
    }

    public boolean isErrorEnabled() {
        return super.isErrorEnabled() && this.loggerProxy.isErrorEnabled(this.implementationLogger);
    }

    public boolean isEnabled(Level level) {
        return super.isEnabled(level) && this.loggerProxy.isEnabled(this.implementationLogger, level);
    }

    @Override
    public void error(Throwable throwable, Object message) {
        if (this.isErrorEnabled()) {
            if (LogListener.present()) {
                LogListener.invokeAll(Instant.now(this.getClock()), this, Level.ERROR, message, throwable);
            }
            String messageString = String.valueOf(message);
            if (ProxyLogger.isAllASCII(message.toString())) {
                this.loggerProxy.error(this.implementationLogger, messageString, throwable);
            } else {
                ProxyLogger.outputMultiLine(messageString, s -> this.loggerProxy.error(this.implementationLogger, (String)s));
                this.loggerProxy.error(this.implementationLogger, "", throwable);
            }
        }
    }

    public void log(Level level, Supplier<Object> messageSupplier) {
        if (this.isEnabled(level)) {
            this.outputLog(level, messageSupplier.get());
        }
    }

    @Override
    public void log(Instant time, Level level, Object message) {
        this.log(level, message);
    }

    @Override
    protected void outputLog(Level level, Object message, Throwable throwable) {
        if (LogListener.present()) {
            LogListener.invokeAll(Instant.now(this.getClock()), this, level, message, throwable);
        }
        ProxyLogger.outputMultiLine(String.valueOf(message), s -> this.loggerProxy.log(this.implementationLogger, level, (String)s));
    }

    @Override
    protected void outputLog(Instant time, Level level, Object message, Throwable throwable) {
        this.outputLog(level, message, throwable);
    }
}

