/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.common.internal.workingtime;

import io.kadai.common.api.LocalTimeInterval;
import io.kadai.common.api.WorkingTimeCalculator;
import io.kadai.common.api.exceptions.InvalidArgumentException;
import io.kadai.common.internal.logging.LoggingAspect;
import io.kadai.common.internal.workingtime.HolidaySchedule;
import io.kadai.common.internal.workingtime.WorkingTimeSchedule;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class WorkingTimeCalculatorImpl
implements WorkingTimeCalculator {
    private final ZoneId zoneId;
    private final HolidaySchedule holidaySchedule;
    private final WorkingTimeSchedule workingTimeSchedule;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;

    public WorkingTimeCalculatorImpl(HolidaySchedule holidaySchedule, Map<DayOfWeek, Set<LocalTimeInterval>> workingTimeSchedule, ZoneId zoneId) {
        this.holidaySchedule = holidaySchedule;
        this.workingTimeSchedule = new WorkingTimeSchedule(workingTimeSchedule);
        this.zoneId = Objects.requireNonNull(zoneId);
    }

    private static boolean isBeforeOrEquals(LocalTime time, ZonedDateTime currentDateTime) {
        boolean bl;
        LocalTime localTime = time;
        ZonedDateTime zonedDateTime = currentDateTime;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)localTime, (Object)zonedDateTime);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl2 = !time.isAfter(currentDateTime.toLocalTime());
        boolean bl3 = bl = bl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl));
        return bl2;
    }

    private static ZonedDateTime max(ZonedDateTime a, ZonedDateTime b) {
        ZonedDateTime zonedDateTime;
        ZonedDateTime zonedDateTime2;
        ZonedDateTime zonedDateTime3 = a;
        ZonedDateTime zonedDateTime4 = b;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)zonedDateTime3, (Object)zonedDateTime4);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ZonedDateTime zonedDateTime5 = zonedDateTime2 = a.isAfter(b) ? (zonedDateTime = a) : (zonedDateTime = b);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)zonedDateTime2);
        return zonedDateTime;
    }

    private static ZonedDateTime min(ZonedDateTime a, ZonedDateTime b) {
        ZonedDateTime zonedDateTime;
        ZonedDateTime zonedDateTime2;
        ZonedDateTime zonedDateTime3 = a;
        ZonedDateTime zonedDateTime4 = b;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)zonedDateTime3, (Object)zonedDateTime4);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ZonedDateTime zonedDateTime5 = zonedDateTime2 = a.isBefore(b) ? (zonedDateTime = a) : (zonedDateTime = b);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)zonedDateTime2);
        return zonedDateTime;
    }

    @Override
    public Instant subtractWorkingTime(Instant workStart, Duration workingTime) throws InvalidArgumentException {
        Instant instant;
        Instant instant2;
        Instant instant3 = workStart;
        Duration duration = workingTime;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)instant3, (Object)duration);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.validatePositiveDuration(workingTime);
        ZonedDateTime workStartInTimeZone = this.toZonedDateTime(workStart);
        WorkSlot workSlot = this.getWorkSlotOrPrevious(workStartInTimeZone);
        Instant instant4 = instant2 = (instant = workSlot.subtractWorkingTime(workStartInTimeZone, workingTime).toInstant());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    @Override
    public Instant addWorkingTime(Instant workStart, Duration workingTime) throws InvalidArgumentException {
        Instant instant;
        Instant instant2;
        Instant instant3 = workStart;
        Duration duration = workingTime;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)instant3, (Object)duration);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.validatePositiveDuration(workingTime);
        ZonedDateTime workStartInTimeZone = this.toZonedDateTime(workStart);
        WorkSlot workSlot = this.getWorkSlotOrNext(workStartInTimeZone);
        Instant instant4 = instant2 = (instant = workSlot.addWorkingTime(workStartInTimeZone, workingTime).toInstant());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    @Override
    public Duration workingTimeBetween(Instant first, Instant second) throws InvalidArgumentException {
        Duration duration;
        Duration duration2;
        Instant to;
        Instant from;
        Instant instant = first;
        Instant instant2 = second;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)instant, (Object)instant2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.validateNonNullInstants(first, second);
        if (first.isAfter(second)) {
            from = second;
            to = first;
        } else {
            from = first;
            to = second;
        }
        Duration duration3 = duration2 = (duration = this.calculateWorkingTime(this.toZonedDateTime(from), this.toZonedDateTime(to)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    @Override
    public boolean isWorkingDay(Instant instant) {
        boolean bl;
        boolean bl2;
        Instant instant2 = instant;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)instant2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = this.workingTimeSchedule.isWorkingDay(this.toDayOfWeek(instant)) && !this.isHoliday(instant) ? (bl = true) : (bl = false);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    @Override
    public boolean isWeekend(Instant instant) {
        boolean bl;
        boolean bl2;
        Instant instant2 = instant;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)instant2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        DayOfWeek dayOfWeek = this.toDayOfWeek(instant);
        boolean bl3 = bl2 = dayOfWeek != DayOfWeek.SATURDAY && dayOfWeek != DayOfWeek.SUNDAY ? (bl = false) : (bl = true);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    @Override
    public boolean isHoliday(Instant instant) {
        boolean bl;
        boolean bl2;
        Instant instant2 = instant;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)instant2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.holidaySchedule.isHoliday(this.toLocalDate(instant)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    @Override
    public boolean isGermanHoliday(Instant instant) {
        boolean bl;
        boolean bl2;
        Instant instant2 = instant;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)instant2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.holidaySchedule.isGermanHoliday(this.toLocalDate(instant)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    private Duration calculateWorkingTime(ZonedDateTime from, ZonedDateTime to) throws InvalidArgumentException {
        Duration duration;
        Duration duration2;
        ZonedDateTime zonedDateTime = from;
        ZonedDateTime zonedDateTime2 = to;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)zonedDateTime, (Object)zonedDateTime2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkSlot bestMatchingWorkSlot = this.getWorkSlotOrNext(from);
        ZonedDateTime earliestWorkStart = WorkingTimeCalculatorImpl.max(from, bestMatchingWorkSlot.start);
        ZonedDateTime endOfWorkSlot = bestMatchingWorkSlot.end;
        Duration duration3 = duration2 = endOfWorkSlot.compareTo(to) >= 0 ? (bestMatchingWorkSlot.start.compareTo(to) <= 0 ? (duration = Duration.between(earliestWorkStart, to)) : (duration = Duration.ZERO)) : (duration = Duration.between(earliestWorkStart, endOfWorkSlot).plus(this.calculateWorkingTime(endOfWorkSlot, to)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    private void validateNonNullInstants(Instant first, Instant second) {
        Instant instant = first;
        Instant instant2 = second;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)instant, (Object)instant2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (first == null || second == null) {
            throw new InvalidArgumentException("Neither first nor second may be null.");
        }
        Object var6_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
    }

    private void validatePositiveDuration(Duration workingTime) {
        Duration duration = workingTime;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)duration);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (workingTime.isNegative()) {
            throw new InvalidArgumentException("Duration must be zero or positive.");
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private WorkSlot getWorkSlotOrNext(ZonedDateTime currentDateTime) {
        WorkSlot workSlot;
        WorkSlot workSlot2;
        WorkSlot workSlot3;
        ZonedDateTime zonedDateTime = currentDateTime;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)zonedDateTime);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        LocalDate currentDate = currentDateTime.toLocalDate();
        if (this.holidaySchedule.isHoliday(currentDate)) {
            workSlot2 = workSlot3 = this.getWorkSlotOrNext(this.getDayAfter(currentDateTime));
        } else {
            SortedSet<LocalTimeInterval> workSlotsOfWorkingDay = this.workingTimeSchedule.workSlotsFor(currentDate.getDayOfWeek());
            Optional<LocalTimeInterval> workSlotEndingAfterCurrentTime = workSlotsOfWorkingDay.stream().filter(it -> ((LocalTime)it.getEnd()).isAfter(currentDateTime.toLocalTime())).findFirst();
            workSlot2 = workSlot3 = workSlotEndingAfterCurrentTime.map(it -> new WorkSlot(currentDate, (LocalTimeInterval)it)).orElseGet(() -> this.getWorkSlotOrNext(this.getDayAfter(currentDateTime)));
        }
        WorkSlot workSlot4 = workSlot = workSlot2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workSlot);
        return workSlot3;
    }

    private WorkSlot getWorkSlotOrPrevious(ZonedDateTime currentDateTime) {
        WorkSlot workSlot;
        WorkSlot workSlot2;
        WorkSlot workSlot3;
        ZonedDateTime zonedDateTime = currentDateTime;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)zonedDateTime);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        LocalDate currentDate = currentDateTime.toLocalDate();
        if (this.holidaySchedule.isHoliday(currentDate)) {
            workSlot2 = workSlot3 = this.getWorkSlotOrPrevious(this.getDayBefore(currentDateTime));
        } else {
            SortedSet<LocalTimeInterval> workSlotsOfWorkingDay = this.workingTimeSchedule.workSlotsForReversed(currentDate.getDayOfWeek());
            Optional<LocalTimeInterval> workSlotStartingBeforeCurrentTime = workSlotsOfWorkingDay.stream().filter(it -> WorkingTimeCalculatorImpl.isBeforeOrEquals((LocalTime)it.getBegin(), currentDateTime)).findFirst();
            workSlot2 = workSlot3 = workSlotStartingBeforeCurrentTime.map(it -> new WorkSlot(currentDate, (LocalTimeInterval)it)).orElseGet(() -> this.getWorkSlotOrPrevious(this.getDayBefore(currentDateTime)));
        }
        WorkSlot workSlot4 = workSlot = workSlot2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workSlot);
        return workSlot3;
    }

    private ZonedDateTime getDayAfter(ZonedDateTime current) {
        ZonedDateTime zonedDateTime;
        ZonedDateTime zonedDateTime2;
        ZonedDateTime zonedDateTime3 = current;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)zonedDateTime3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ZonedDateTime zonedDateTime4 = zonedDateTime2 = (zonedDateTime = LocalDateTime.of(current.toLocalDate().plusDays(1L), LocalTime.MIN).atZone(current.getZone()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)zonedDateTime2);
        return zonedDateTime;
    }

    private DayOfWeek toDayOfWeek(Instant instant) {
        DayOfWeek dayOfWeek;
        DayOfWeek dayOfWeek2;
        Instant instant2 = instant;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)instant2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        DayOfWeek dayOfWeek3 = dayOfWeek2 = (dayOfWeek = this.toLocalDate(instant).getDayOfWeek());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)dayOfWeek2);
        return dayOfWeek;
    }

    private ZonedDateTime getDayBefore(ZonedDateTime current) {
        ZonedDateTime zonedDateTime;
        ZonedDateTime zonedDateTime2;
        ZonedDateTime zonedDateTime3 = current;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)zonedDateTime3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ZonedDateTime zonedDateTime4 = zonedDateTime2 = (zonedDateTime = LocalDateTime.of(current.toLocalDate().minusDays(1L), LocalTime.MAX).atZone(current.getZone()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)zonedDateTime2);
        return zonedDateTime;
    }

    private ZonedDateTime toZonedDateTime(Instant instant) {
        ZonedDateTime zonedDateTime;
        ZonedDateTime zonedDateTime2;
        Instant instant2 = instant;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)instant2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ZonedDateTime zonedDateTime3 = zonedDateTime2 = (zonedDateTime = instant.atZone(this.zoneId));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)zonedDateTime2);
        return zonedDateTime;
    }

    private ZonedDateTime toZonedDateTime(LocalDateTime localDateTime) {
        ZonedDateTime zonedDateTime;
        ZonedDateTime zonedDateTime2;
        LocalDateTime localDateTime2 = localDateTime;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)localDateTime2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ZonedDateTime zonedDateTime3 = zonedDateTime2 = (zonedDateTime = localDateTime.atZone(this.zoneId));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)zonedDateTime2);
        return zonedDateTime;
    }

    private ZonedDateTime toZonedDateTime(LocalDate day, LocalTime time) {
        ZonedDateTime zonedDateTime;
        ZonedDateTime zonedDateTime2;
        LocalDate localDate = day;
        LocalTime localTime = time;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)localDate, (Object)localTime);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ZonedDateTime zonedDateTime3 = zonedDateTime2 = (zonedDateTime = this.toZonedDateTime(LocalDateTime.of(day, time)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)zonedDateTime2);
        return zonedDateTime;
    }

    private LocalDate toLocalDate(Instant instant) {
        LocalDate localDate;
        LocalDate localDate2;
        Instant instant2 = instant;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)instant2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        LocalDate localDate3 = localDate2 = (localDate = LocalDate.ofInstant(instant, this.zoneId));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)localDate2);
        return localDate;
    }

    static {
        WorkingTimeCalculatorImpl.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WorkingTimeCalculatorImpl.java", WorkingTimeCalculatorImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "isBeforeOrEquals", "io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl", "java.time.LocalTime:java.time.ZonedDateTime", "time:currentDateTime", "", "boolean"), 54);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "max", "io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl", "java.time.ZonedDateTime:java.time.ZonedDateTime", "a:b", "", "java.time.ZonedDateTime"), 58);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "calculateWorkingTime", "io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl", "java.time.ZonedDateTime:java.time.ZonedDateTime", "from:to", "io.kadai.common.api.exceptions.InvalidArgumentException", "java.time.Duration"), 131);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validateNonNullInstants", "io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl", "java.time.Instant:java.time.Instant", "first:second", "", "void"), 154);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validatePositiveDuration", "io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl", "java.time.Duration", "workingTime", "", "void"), 160);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getWorkSlotOrNext", "io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl", "java.time.ZonedDateTime", "currentDateTime", "", "io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl$WorkSlot"), 175);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getWorkSlotOrPrevious", "io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl", "java.time.ZonedDateTime", "currentDateTime", "", "io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl$WorkSlot"), 206);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getDayAfter", "io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl", "java.time.ZonedDateTime", "current", "", "java.time.ZonedDateTime"), 230);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toDayOfWeek", "io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl", "java.time.Instant", "instant", "", "java.time.DayOfWeek"), 235);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getDayBefore", "io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl", "java.time.ZonedDateTime", "current", "", "java.time.ZonedDateTime"), 239);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toZonedDateTime", "io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl", "java.time.Instant", "instant", "", "java.time.ZonedDateTime"), 244);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toZonedDateTime", "io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl", "java.time.LocalDateTime", "localDateTime", "", "java.time.ZonedDateTime"), 248);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "min", "io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl", "java.time.ZonedDateTime:java.time.ZonedDateTime", "a:b", "", "java.time.ZonedDateTime"), 66);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toZonedDateTime", "io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl", "java.time.LocalDate:java.time.LocalTime", "day:time", "", "java.time.ZonedDateTime"), 252);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toLocalDate", "io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl", "java.time.Instant", "instant", "", "java.time.LocalDate"), 256);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "subtractWorkingTime", "io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl", "java.time.Instant:java.time.Duration", "workStart:workingTime", "io.kadai.common.api.exceptions.InvalidArgumentException", "java.time.Instant"), 75);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addWorkingTime", "io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl", "java.time.Instant:java.time.Duration", "workStart:workingTime", "io.kadai.common.api.exceptions.InvalidArgumentException", "java.time.Instant"), 84);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "workingTimeBetween", "io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl", "java.time.Instant:java.time.Instant", "first:second", "io.kadai.common.api.exceptions.InvalidArgumentException", "java.time.Duration"), 93);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isWorkingDay", "io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl", "java.time.Instant", "instant", "", "boolean"), 111);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isWeekend", "io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl", "java.time.Instant", "instant", "", "boolean"), 116);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isHoliday", "io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl", "java.time.Instant", "instant", "", "boolean"), 122);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isGermanHoliday", "io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl", "java.time.Instant", "instant", "", "boolean"), 127);
    }

    class WorkSlot {
        private final ZonedDateTime start;
        private final ZonedDateTime end;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

        public WorkSlot(LocalDate day, LocalTimeInterval interval) {
            this.start = WorkingTimeCalculatorImpl.this.toZonedDateTime(day, (LocalTime)interval.getBegin());
            this.end = ((LocalTime)interval.getEnd()).equals(LocalTime.MAX) ? WorkingTimeCalculatorImpl.this.toZonedDateTime(day.plusDays(1L).atStartOfDay()) : WorkingTimeCalculatorImpl.this.toZonedDateTime(day, (LocalTime)interval.getEnd());
        }

        private ZonedDateTime subtractWorkingTime(ZonedDateTime workStart, Duration workingTime) {
            ZonedDateTime zonedDateTime;
            ZonedDateTime zonedDateTime2;
            ZonedDateTime zonedDateTime3;
            ZonedDateTime zonedDateTime4 = workStart;
            Duration duration = workingTime;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)zonedDateTime4, (Object)duration);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            ZonedDateTime latestWorkEnd = WorkingTimeCalculatorImpl.min(workStart, this.end);
            Duration untilStartOfWorkSlot = Duration.between(this.start, latestWorkEnd);
            if (workingTime.compareTo(untilStartOfWorkSlot) <= 0) {
                zonedDateTime2 = zonedDateTime3 = latestWorkEnd.minus(workingTime);
            } else {
                Duration remainingWorkingTime = workingTime.minus(untilStartOfWorkSlot);
                zonedDateTime2 = zonedDateTime3 = this.previous().subtractWorkingTime(this.start, remainingWorkingTime);
            }
            ZonedDateTime zonedDateTime5 = zonedDateTime = zonedDateTime2;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)zonedDateTime);
            return zonedDateTime3;
        }

        private ZonedDateTime addWorkingTime(ZonedDateTime workStart, Duration workingTime) {
            ZonedDateTime zonedDateTime;
            ZonedDateTime zonedDateTime2;
            ZonedDateTime zonedDateTime3;
            ZonedDateTime zonedDateTime4 = workStart;
            Duration duration = workingTime;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)zonedDateTime4, (Object)duration);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            ZonedDateTime earliestWorkStart = WorkingTimeCalculatorImpl.max(workStart, this.start);
            Duration untilEndOfWorkSlot = Duration.between(earliestWorkStart, this.end);
            if (workingTime.compareTo(untilEndOfWorkSlot) <= 0) {
                zonedDateTime2 = zonedDateTime3 = earliestWorkStart.plus(workingTime);
            } else {
                Duration remainingWorkingTime = workingTime.minus(untilEndOfWorkSlot);
                zonedDateTime2 = zonedDateTime3 = this.next().addWorkingTime(this.end, remainingWorkingTime);
            }
            ZonedDateTime zonedDateTime5 = zonedDateTime = zonedDateTime2;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)zonedDateTime);
            return zonedDateTime3;
        }

        private WorkSlot previous() {
            WorkSlot workSlot;
            WorkSlot workSlot2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            WorkSlot workSlot3 = workSlot2 = (workSlot = WorkingTimeCalculatorImpl.this.getWorkSlotOrPrevious(this.start.minusNanos(1L)));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workSlot2);
            return workSlot;
        }

        private WorkSlot next() {
            WorkSlot workSlot;
            WorkSlot workSlot2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            WorkSlot workSlot3 = workSlot2 = (workSlot = WorkingTimeCalculatorImpl.this.getWorkSlotOrNext(this.end));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workSlot2);
            return workSlot;
        }

        static {
            WorkSlot.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("WorkingTimeCalculatorImpl.java", WorkSlot.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "subtractWorkingTime", "io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl$WorkSlot", "java.time.ZonedDateTime:java.time.Duration", "workStart:workingTime", "", "java.time.ZonedDateTime"), 274);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addWorkingTime", "io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl$WorkSlot", "java.time.ZonedDateTime:java.time.Duration", "workStart:workingTime", "", "java.time.ZonedDateTime"), 287);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "previous", "io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl$WorkSlot", "", "", "", "io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl$WorkSlot"), 303);
            ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "next", "io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl$WorkSlot", "", "", "", "io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl$WorkSlot"), 308);
        }
    }
}

