/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.common.internal.configuration;

import io.kadai.common.internal.configuration.DB;
import io.kadai.common.internal.logging.LoggingAspect;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.ibatis.jdbc.RuntimeSqlException;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbSchemaCreator {
    private static final Logger LOGGER;
    private final String schemaName;
    private final StringWriter outWriter = new StringWriter();
    private final PrintWriter logWriter = new PrintWriter(this.outWriter);
    private final StringWriter errorWriter = new StringWriter();
    private final PrintWriter errorLogWriter = new PrintWriter(this.errorWriter);
    private DataSource dataSource;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    static {
        DbSchemaCreator.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(DbSchemaCreator.class);
    }

    public DbSchemaCreator(DataSource dataSource, String schema) {
        this.dataSource = dataSource;
        this.schemaName = schema;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean run() throws SQLException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        JoinPoint joinPoint;
        block12: {
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                Connection connection;
                block10: {
                    block11: {
                        connection = this.dataSource.getConnection();
                        try {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Using database of type {} with url '{}'", (Object)DB.getDB((Connection)connection).dbProductName, (Object)connection.getMetaData().getURL());
                            }
                            DB db = DB.getDB(connection);
                            ScriptRunner runner = this.getScriptRunnerInstance(connection);
                            if (this.isSchemaPreexisting(connection, db)) break block10;
                            String scriptPath = db.schemaScript;
                            InputStream resourceAsStream = DbSchemaCreator.class.getResourceAsStream(scriptPath);
                            BufferedReader reader = new BufferedReader(new InputStreamReader(resourceAsStream, StandardCharsets.UTF_8));
                            runner.runScript((Reader)this.getSqlSchemaNameParsed(reader));
                            if (connection == null) break block11;
                        }
                        catch (Throwable throwable2) {
                            if (connection == null) throw throwable2;
                            connection.close();
                            throw throwable2;
                        }
                        connection.close();
                    }
                    bl2 = bl3 = true;
                    break block12;
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this.outWriter.toString());
            }
            if (!this.errorWriter.getBuffer().isEmpty()) {
                String errorLogMessage = this.errorWriter.toString();
                LOGGER.error(errorLogMessage);
            }
            bl2 = bl3 = false;
        }
        boolean bl4 = bl = bl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl));
        return bl3;
    }

    /*
     * Exception decompiling
     */
    public boolean isValidSchemaVersion(String expectedMinVersion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DataSource getDataSource() {
        DataSource dataSource;
        DataSource dataSource2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        DataSource dataSource3 = dataSource2 = (dataSource = this.dataSource);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)dataSource2);
        return dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        DataSource dataSource2 = dataSource;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)dataSource2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.dataSource = dataSource;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private ScriptRunner getScriptRunnerInstance(Connection connection) {
        ScriptRunner scriptRunner;
        ScriptRunner scriptRunner2;
        Connection connection2 = connection;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)connection2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ScriptRunner runner = new ScriptRunner(connection);
        runner.setStopOnError(true);
        runner.setLogWriter(this.logWriter);
        runner.setErrorLogWriter(this.errorLogWriter);
        ScriptRunner scriptRunner3 = scriptRunner2 = (scriptRunner = runner);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)scriptRunner2);
        return scriptRunner;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSchemaPreexisting(Connection connection, DB db) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        JoinPoint joinPoint;
        block25: {
            block24: {
                Connection connection2 = connection;
                DB dB = db;
                joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)connection2, (Object)((Object)dB));
                LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
                ScriptRunner runner = this.getScriptRunnerInstance(connection);
                runner.setErrorLogWriter(this.errorLogWriter);
                String scriptPath = db.detectionScript;
                try {
                    Throwable throwable = null;
                    Object var6_10 = null;
                    try {
                        InputStream resource = DbSchemaCreator.class.getResourceAsStream(scriptPath);
                        try {
                            block23: {
                                InputStreamReader inputReader = new InputStreamReader(resource, StandardCharsets.UTF_8);
                                try {
                                    try (BufferedReader reader = new BufferedReader(inputReader);){
                                        runner.runScript((Reader)this.getSqlSchemaNameParsed(reader));
                                    }
                                    if (inputReader == null) break block23;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    if (inputReader == null) throw throwable;
                                    inputReader.close();
                                    throw throwable;
                                }
                                inputReader.close();
                            }
                            if (resource == null) break block24;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (resource == null) throw throwable;
                            resource.close();
                            throw throwable;
                        }
                        resource.close();
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                            throw throwable;
                        }
                        if (throwable == throwable4) throw throwable;
                        throwable.addSuppressed(throwable4);
                        throw throwable;
                    }
                }
                catch (IOException | RuntimeSqlException throwable) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Schema does not exist.");
                        if (!this.errorWriter.toString().trim().isEmpty()) {
                            LOGGER.debug(this.errorWriter.toString());
                        }
                    }
                    bl2 = bl3 = false;
                    break block25;
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Schema does exist.");
            }
            bl2 = bl3 = true;
        }
        boolean bl4 = bl = bl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl));
        return bl3;
    }

    private StringReader getSqlSchemaNameParsed(BufferedReader reader) {
        StringReader stringReader;
        StringReader stringReader2;
        BufferedReader bufferedReader = reader;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)bufferedReader);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        StringBuilder content = new StringBuilder();
        try {
            String line = "";
            while (line != null) {
                line = reader.readLine();
                if (line == null) continue;
                content.append(line.replace("%schemaName%", this.schemaName)).append(System.lineSeparator());
            }
        }
        catch (IOException e) {
            LOGGER.error("SchemaName sql parsing failed for schemaName {}", (Object)this.schemaName, (Object)e);
        }
        StringReader stringReader3 = stringReader2 = (stringReader = new StringReader(content.toString()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringReader2);
        return stringReader;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DbSchemaCreator.java", DbSchemaCreator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "io.kadai.common.internal.configuration.DbSchemaCreator", "", "", "java.sql.SQLException", "boolean"), 62);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isValidSchemaVersion", "io.kadai.common.internal.configuration.DbSchemaCreator", "java.lang.String", "expectedMinVersion", "", "boolean"), 93);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDataSource", "io.kadai.common.internal.configuration.DbSchemaCreator", "", "", "", "javax.sql.DataSource"), 132);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDataSource", "io.kadai.common.internal.configuration.DbSchemaCreator", "javax.sql.DataSource", "dataSource", "", "void"), 136);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getScriptRunnerInstance", "io.kadai.common.internal.configuration.DbSchemaCreator", "java.sql.Connection", "connection", "", "org.apache.ibatis.jdbc.ScriptRunner"), 140);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isSchemaPreexisting", "io.kadai.common.internal.configuration.DbSchemaCreator", "java.sql.Connection:io.kadai.common.internal.configuration.DB", "connection:db", "", "boolean"), 148);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getSqlSchemaNameParsed", "io.kadai.common.internal.configuration.DbSchemaCreator", "java.io.BufferedReader", "reader", "", "java.io.StringReader"), 172);
    }
}

